/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.web.impl;

import java.util.EventListener;
import java.util.Set;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdiServletContainerInitializer
implements ServletContainerInitializer {
    private static Logger log = LoggerFactory.getLogger(CdiServletContainerInitializer.class);
    private CdiContainer cdiContainer;
    private ServletContextListener servletContextListener;

    public CdiServletContainerInitializer(CdiContainer cdiContainer, ServletContextListener servletContextListener) {
        this.cdiContainer = cdiContainer;
        this.servletContextListener = servletContextListener;
    }

    public void onStartup(Set<Class<?>> classes, ServletContext ctx) throws ServletException {
        Bundle bundle = this.cdiContainer.getBundle();
        log.info("storing CdiContainer in ServletContext for [{}]", (Object)bundle);
        String contextId = String.format("%s:%d", bundle.getSymbolicName(), bundle.getBundleId());
        ctx.setInitParameter("WELD_CONTEXT_ID_KEY", contextId);
        ctx.setAttribute("org.ops4j.pax.cdi.container", (Object)this.cdiContainer);
        ctx.addListener((EventListener)this.servletContextListener);
    }
}

