/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import jline.Terminal;
import org.apache.felix.gogo.commands.Action;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.CommandException;
import org.apache.felix.gogo.commands.basic.AbstractCommand;
import org.apache.felix.gogo.runtime.CommandNotFoundException;
import org.apache.felix.gogo.runtime.CommandProcessorImpl;
import org.apache.felix.gogo.runtime.threadio.ThreadIOImpl;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Function;
import org.apache.felix.service.threadio.ThreadIO;
import org.apache.karaf.shell.console.jline.Console;
import org.apache.karaf.shell.console.jline.TerminalFactory;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class Main {
    private String application = System.getProperty("karaf.name", "root");
    private String user = "karaf";

    public static void main(String[] args) throws Exception {
        Main main = new Main();
        main.run(args);
    }

    public void run(String[] args) throws Exception {
        ThreadIOImpl threadio = new ThreadIOImpl();
        threadio.start();
        CommandProcessorImpl commandProcessor = new CommandProcessorImpl(threadio);
        InputStream in = Main.unwrap(System.in);
        PrintStream out = Main.wrap(Main.unwrap(System.out));
        PrintStream err = Main.wrap(Main.unwrap(System.err));
        this.run(commandProcessor, (ThreadIO)threadio, args, in, out, err);
    }

    public void run(CommandSession parent, ThreadIO threadIO, String[] args) throws Exception {
        CommandProcessorImpl commandProcessor = new CommandProcessorImpl(new ThreadIO(){

            @Override
            public void setStreams(InputStream in, PrintStream out, PrintStream err) {
            }

            @Override
            public void close() {
            }
        });
        InputStream in = parent.getKeyboard();
        PrintStream out = parent.getConsole();
        PrintStream err = parent.getConsole();
        this.run(commandProcessor, threadIO, args, in, out, err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run(CommandProcessorImpl commandProcessor, ThreadIO threadIO, String[] args, InputStream in, PrintStream out, PrintStream err) throws Exception {
        StringBuilder sb = new StringBuilder();
        String classpath = null;
        boolean batch = false;
        String file = null;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("--classpath=")) {
                classpath = arg.substring("--classpath=".length());
                continue;
            }
            if (arg.startsWith("-c=")) {
                classpath = arg.substring("-c=".length());
                continue;
            }
            if (arg.equals("--classpath") || arg.equals("-c")) {
                classpath = args[++i];
                continue;
            }
            if (arg.equals("-b") || arg.equals("--batch")) {
                batch = true;
                continue;
            }
            if (arg.startsWith("--file=")) {
                file = arg.substring("--file=".length());
                continue;
            }
            if (arg.startsWith("-f=")) {
                file = arg.substring("-f=".length());
                continue;
            }
            if (arg.equals("--file") || arg.equals("-f")) {
                file = args[++i];
                continue;
            }
            sb.append(arg);
            sb.append(' ');
        }
        if (file != null) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));){
                sb.setLength(0);
                int c = ((Reader)reader).read();
                while (c >= 0) {
                    sb.append((char)c);
                    c = ((Reader)reader).read();
                }
            }
        } else if (batch) {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            sb.setLength(0);
            int c = ((Reader)reader).read();
            while (c >= 0) {
                sb.append((char)c);
                c = ((Reader)reader).read();
            }
        }
        ClassLoader cl = Main.class.getClassLoader();
        if (classpath != null) {
            List<URL> urls = Main.getFiles(new File(classpath));
            cl = new URLClassLoader(urls.toArray(new URL[urls.size()]), cl);
        }
        this.discoverCommands(commandProcessor, cl);
        this.run(commandProcessor, threadIO, sb.toString(), in, out, err);
    }

    private void run(CommandProcessorImpl commandProcessor, ThreadIO threadIO, String command, InputStream in, PrintStream out, PrintStream err) throws Exception {
        block7: {
            if (command.length() > 0) {
                CommandSession session = commandProcessor.createSession(in, out, err);
                session.put("USER", this.user);
                session.put("APPLICATION", this.application);
                session.put("MULTI_SCOPE_MODE", Boolean.toString(this.isMultiScopeMode()));
                try {
                    session.execute(command);
                }
                catch (Throwable t) {
                    if (t instanceof CommandNotFoundException) {
                        String str = Ansi.ansi().fg(Ansi.Color.RED).a("Command not found: ").a(Ansi.Attribute.INTENSITY_BOLD).a(((CommandNotFoundException)t).getCommand()).a(Ansi.Attribute.INTENSITY_BOLD_OFF).fg(Ansi.Color.DEFAULT).toString();
                        session.getConsole().println(str);
                        break block7;
                    }
                    if (t instanceof CommandException) {
                        session.getConsole().println(((CommandException)t).getNiceHelp());
                        break block7;
                    }
                    session.getConsole().print(Ansi.ansi().fg(Ansi.Color.RED).toString());
                    t.printStackTrace(session.getConsole());
                    session.getConsole().print(Ansi.ansi().fg(Ansi.Color.DEFAULT).toString());
                }
            } else {
                TerminalFactory terminalFactory = new TerminalFactory();
                final Terminal terminal = terminalFactory.getTerminal();
                Console console = this.createConsole(commandProcessor, threadIO, in, out, err, terminal);
                CommandSession session = console.getSession();
                for (Object o : System.getProperties().keySet()) {
                    String key = o.toString();
                    session.put(key, System.getProperty(key));
                }
                session.put("USER", this.user);
                session.put("APPLICATION", this.application);
                session.put("MULTI_SCOPE_MODE", Boolean.toString(this.isMultiScopeMode()));
                session.put("#LINES", new Function(){

                    @Override
                    public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                        return Integer.toString(terminal.getHeight());
                    }
                });
                session.put("#COLUMNS", new Function(){

                    @Override
                    public Object execute(CommandSession session, List<Object> arguments) throws Exception {
                        return Integer.toString(terminal.getWidth());
                    }
                });
                session.put(".jline.terminal", terminal);
                console.run();
                terminalFactory.destroy();
            }
        }
    }

    protected Console createConsole(CommandProcessorImpl commandProcessor, ThreadIO threadIO, InputStream in, PrintStream out, PrintStream err, Terminal terminal) throws Exception {
        return new Console(commandProcessor, threadIO, in, out, err, terminal, null, null, null);
    }

    public String getDiscoveryResource() {
        return "META-INF/services/org/apache/karaf/shell/commands";
    }

    private void discoverCommands(CommandProcessorImpl commandProcessor, ClassLoader cl) throws IOException, ClassNotFoundException {
        Enumeration<URL> urls = cl.getResources(this.getDiscoveryResource());
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));
            String line = r.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0 && line.charAt(0) != '#') {
                    final Class<?> actionClass = cl.loadClass(line);
                    Command cmd = actionClass.getAnnotation(Command.class);
                    AbstractCommand function = new AbstractCommand(){

                        @Override
                        public Action createNewAction() {
                            try {
                                return (Action)actionClass.newInstance();
                            }
                            catch (InstantiationException e) {
                                throw new RuntimeException(e);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    };
                    this.addCommand(cmd, function, commandProcessor);
                }
                line = r.readLine();
            }
            r.close();
        }
    }

    protected void addCommand(Command cmd, Function function, CommandProcessorImpl commandProcessor) {
        try {
            commandProcessor.addCommand(cmd.scope(), (Object)function, cmd.name());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getApplication() {
        return this.application;
    }

    public void setApplication(String application) {
        this.application = application;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public boolean isMultiScopeMode() {
        return true;
    }

    private static PrintStream wrap(PrintStream stream) {
        OutputStream o = AnsiConsole.wrapOutputStream(stream);
        if (o instanceof PrintStream) {
            return (PrintStream)o;
        }
        return new PrintStream(o);
    }

    private static <T> T unwrap(T stream) {
        try {
            Method mth = stream.getClass().getMethod("getRoot", new Class[0]);
            return (T)mth.invoke(stream, new Object[0]);
        }
        catch (Throwable t) {
            return stream;
        }
    }

    private static List<URL> getFiles(File base) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        Main.getFiles(base, urls);
        return urls;
    }

    private static void getFiles(File base, List<URL> urls) throws MalformedURLException {
        for (File f : base.listFiles()) {
            if (f.isDirectory()) {
                Main.getFiles(f, urls);
                continue;
            }
            if (!f.getName().endsWith(".jar")) continue;
            urls.add(f.toURI().toURL());
        }
    }
}

