/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.console;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.karaf.shell.console.CommandLoggingFilter;

public class RegexCommandLoggingFilter
implements CommandLoggingFilter {
    public static final String DEFAULT_REPLACEMENT = "*****";
    private String pattern;
    private int group = 1;
    private String replacement = "*****";
    ArrayList<ReplaceRegEx> regexs = new ArrayList();

    @Override
    public CharSequence filter(CharSequence command) {
        if (this.pattern != null) {
            command = new ReplaceRegEx(this.pattern, this.group, this.replacement).filter(command);
        }
        for (ReplaceRegEx regex : this.regexs) {
            command = regex.filter(command);
        }
        return command;
    }

    public void addRegEx(String pattern) {
        this.addRegEx(pattern, 1);
    }

    public void addRegEx(String pattern, int group) {
        this.addRegEx(pattern, group, DEFAULT_REPLACEMENT);
    }

    public void addRegEx(String pattern, int group, String replacement) {
        this.regexs.add(new ReplaceRegEx(pattern, group, replacement));
    }

    public void addCommandOption(String option, String ... commands) {
        String pattern = "(";
        for (String command : commands) {
            if (pattern.length() > 1) {
                pattern = pattern + "|";
            }
            pattern = pattern + Pattern.quote(command);
        }
        pattern = pattern + ") +.*?" + Pattern.quote(option) + " +([^ ]+)";
        this.regexs.add(new ReplaceRegEx(pattern, 2, DEFAULT_REPLACEMENT));
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public String getReplacement() {
        return this.replacement;
    }

    public void setReplacement(String replacement) {
        this.replacement = replacement;
    }

    public int getGroup() {
        return this.group;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    private static class ReplaceRegEx {
        private Pattern pattern;
        private int group = 1;
        private String replacement;

        public ReplaceRegEx(String pattern, int group, String replacement) {
            this.pattern = Pattern.compile(";* *" + pattern);
            this.group = group;
            this.replacement = replacement;
        }

        public CharSequence filter(CharSequence command) {
            Matcher m = this.pattern.matcher(command);
            int offset = 0;
            while (m.find()) {
                int origLen = command.length();
                command = new StringBuilder(command).replace(m.start(this.group) + offset, m.end(this.group) + offset, this.replacement).toString();
                offset += command.length() - origLen;
            }
            return command;
        }
    }
}

