/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.diagnostic.common;

import java.io.OutputStreamWriter;
import org.apache.karaf.diagnostic.common.TextDumpProvider;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class FeaturesDumpProvider
extends TextDumpProvider {
    private final BundleContext bundleContext;

    public FeaturesDumpProvider(BundleContext bundleContext) {
        super("features.txt");
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void writeDump(OutputStreamWriter outputStreamWriter) throws Exception {
        ServiceReference ref = this.bundleContext.getServiceReference(FeaturesService.class.getName());
        if (ref == null) {
            return;
        }
        FeaturesService features = (FeaturesService)this.bundleContext.getService(ref);
        try {
            outputStreamWriter.write("Repositories:\n");
            for (Repository repository : features.listRepositories()) {
                outputStreamWriter.write(repository.getURI() + " (" + repository.getName() + ")\n");
            }
            outputStreamWriter.write("\nfeatures:\n");
            for (Repository repository : features.listFeatures()) {
                outputStreamWriter.write(repository.getName() + " " + repository.getVersion());
                outputStreamWriter.write(" installed: " + features.isInstalled((Feature)repository));
                outputStreamWriter.write("\nBundles:\n");
                for (BundleInfo bundle : repository.getBundles()) {
                    outputStreamWriter.write("\t" + bundle.getLocation());
                    if (bundle.getStartLevel() != 0) {
                        outputStreamWriter.write(" start level " + bundle.getStartLevel());
                    }
                    outputStreamWriter.write("\n\n");
                }
            }
            outputStreamWriter.close();
        }
        finally {
            this.bundleContext.ungetService(ref);
        }
    }
}

