/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.internal;

import java.util.List;
import java.util.Map;
import javax.management.MBeanException;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;
import org.apache.karaf.jms.JmsMBean;
import org.apache.karaf.jms.JmsMessage;
import org.apache.karaf.jms.JmsService;

public class JmsMBeanImpl
extends StandardMBean
implements JmsMBean {
    private JmsService jmsService;

    public JmsMBeanImpl() throws NotCompliantMBeanException {
        super(JmsMBean.class);
    }

    @Override
    public List<String> getConnectionfactories() throws MBeanException {
        try {
            return this.jmsService.connectionFactories();
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    @Override
    public void create(String name, String type, String url) throws MBeanException {
        try {
            this.jmsService.create(name, type, url);
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    @Override
    public void delete(String name) throws MBeanException {
        try {
            this.jmsService.delete(name);
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    @Override
    public Map<String, String> info(String connectionFactory, String username, String password) throws MBeanException {
        try {
            return this.jmsService.info(connectionFactory, username, password);
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    @Override
    public int count(String connectionFactory, String queue, String username, String password) throws MBeanException {
        try {
            return this.jmsService.count(connectionFactory, queue, username, password);
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    @Override
    public List<String> queues(String connectionFactory, String username, String password) throws MBeanException {
        try {
            return this.jmsService.queues(connectionFactory, username, password);
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    @Override
    public List<String> topics(String connectionFactory, String username, String password) throws MBeanException {
        try {
            return this.jmsService.topics(connectionFactory, username, password);
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    @Override
    public void send(String connectionFactory, String queue, String content, String replyTo, String username, String password) throws MBeanException {
        try {
            this.jmsService.send(connectionFactory, queue, content, replyTo, username, password);
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    @Override
    public int consume(String connectionFactory, String queue, String selector, String username, String password) throws MBeanException {
        try {
            return this.jmsService.consume(connectionFactory, queue, selector, username, password);
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    @Override
    public int move(String connectionFactory, String source, String destination, String selector, String username, String password) throws MBeanException {
        try {
            return this.jmsService.move(connectionFactory, source, destination, selector, username, password);
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    @Override
    public TabularData browse(String connectionFactory, String queue, String selector, String username, String password) throws MBeanException {
        try {
            CompositeType type = new CompositeType("message", "JMS Message", new String[]{"id", "content", "charset", "type", "correlation", "delivery", "destination", "expiration", "priority", "redelivered", "replyto", "timestamp"}, new String[]{"Message ID", "Content", "Charset", "Type", "Correlation ID", "Delivery Mode", "Destination", "Expiration Date", "Priority", "Redelivered", "Reply-To", "Timestamp"}, new OpenType[]{SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.STRING, SimpleType.INTEGER, SimpleType.BOOLEAN, SimpleType.STRING, SimpleType.STRING});
            TabularType tableType = new TabularType("messages", "JMS Messages", type, new String[]{"id"});
            TabularDataSupport table = new TabularDataSupport(tableType);
            for (JmsMessage message : this.getJmsService().browse(connectionFactory, queue, selector, username, password)) {
                CompositeDataSupport data = new CompositeDataSupport(type, new String[]{"id", "content", "charset", "type", "correlation", "delivery", "destination", "expiration", "priority", "redelivered", "replyto", "timestamp"}, new Object[]{message.getMessageId(), message.getContent(), message.getCharset(), message.getType(), message.getCorrelationID(), message.getDeliveryMode(), message.getDestination(), message.getExpiration(), message.getPriority(), message.isRedelivered(), message.getReplyTo(), message.getTimestamp()});
                table.put(data);
            }
            return table;
        }
        catch (Throwable t) {
            throw new MBeanException(null, t.getMessage());
        }
    }

    public JmsService getJmsService() {
        return this.jmsService;
    }

    public void setJmsService(JmsService jmsService) {
        this.jmsService = jmsService;
    }
}

