/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.context;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.BeanManager;
import org.ops4j.pax.cdi.api.BundleScoped;
import org.ops4j.pax.cdi.extension.impl.context.BeanMap;
import org.ops4j.pax.cdi.extension.impl.context.SingletonScopeContextEntry;
import org.osgi.framework.Bundle;

@Typed
public class BundleScopeContext
implements Context {
    private Map<Contextual<?>, SingletonScopeContextEntry<?>> serviceBeans = new ConcurrentHashMap();
    private BeanManager beanManager;
    private ThreadLocal<Bundle> clientBundle;
    private Map<Bundle, BeanMap> beanMaps;

    public BundleScopeContext(BeanManager beanManager) {
        this.beanManager = beanManager;
        this.clientBundle = new ThreadLocal();
        this.beanMaps = new HashMap<Bundle, BeanMap>();
    }

    public Class<? extends Annotation> getScope() {
        return BundleScoped.class;
    }

    public <T> T get(Contextual<T> component, CreationalContext<T> creationalContext) {
        BeanMap beanMap = this.getBeanMap(creationalContext);
        SingletonScopeContextEntry<Object> serviceBean = (SingletonScopeContextEntry<Object>)beanMap.get(component);
        if (serviceBean != null) {
            return serviceBean.getContextualInstance();
        }
        Object instance = component.create(creationalContext);
        serviceBean = new SingletonScopeContextEntry<Object>(component, instance, beanMap.getCreationalContext());
        this.serviceBeans.put(component, serviceBean);
        return (T)instance;
    }

    private <T> BeanMap getBeanMap(CreationalContext<T> creationalContext) {
        Bundle bundle = this.getClientBundle();
        if (bundle == null) {
            throw new ContextNotActiveException();
        }
        BeanMap beanMap = this.beanMaps.get(bundle);
        if (beanMap == null) {
            beanMap = new BeanMap();
            if (creationalContext == null) {
                beanMap.setCreationalContext((CreationalContext<Object>)this.beanManager.createCreationalContext(null));
            } else {
                beanMap.setCreationalContext(creationalContext);
            }
            this.beanMaps.put(bundle, beanMap);
        }
        return beanMap;
    }

    public <T> T get(Contextual<T> component) {
        Bundle bundle = this.getClientBundle();
        if (bundle == null) {
            throw new ContextNotActiveException();
        }
        BeanMap beanMap = this.beanMaps.get(bundle);
        if (beanMap == null) {
            throw new ContextNotActiveException();
        }
        SingletonScopeContextEntry serviceBean = (SingletonScopeContextEntry)beanMap.get(component);
        if (serviceBean != null) {
            return serviceBean.getContextualInstance();
        }
        return null;
    }

    public void destroy(Contextual<?> component) {
        SingletonScopeContextEntry<?> serviceBean = this.serviceBeans.get(component);
        if (serviceBean != null) {
            Object instance = serviceBean.getContextualInstance();
            CreationalContext<?> cc = serviceBean.getCreationalContext();
            serviceBean.getBean().destroy(instance, cc);
        }
    }

    public boolean isActive() {
        return true;
    }

    public Bundle getClientBundle() {
        return this.clientBundle.get();
    }

    public void setClientBundle(Bundle clientBundle) {
        if (clientBundle == null) {
            this.clientBundle.remove();
        } else {
            this.clientBundle.set(clientBundle);
        }
    }

    public CreationalContext<?> getCreationalContext() {
        return this.beanManager.createCreationalContext(null);
    }
}

