/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.spi;

import java.util.Map;
import java.util.WeakHashMap;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;

public class Injector {
    private BeanManager beanManager;
    private Map<Class<?>, InjectionTarget<?>> injectionTargets = new WeakHashMap();

    public Injector(BeanManager beanManager) {
        assert (beanManager != null);
        this.beanManager = beanManager;
    }

    public void inject(Object target) {
        Class<?> klass = target.getClass();
        InjectionTarget it = this.injectionTargets.get(klass);
        if (it == null) {
            it = this.beanManager.createInjectionTarget(this.beanManager.createAnnotatedType(klass));
            this.injectionTargets.put(klass, it);
        }
        CreationalContext context = this.beanManager.createCreationalContext(null);
        it.inject(target, context);
    }

    public void destroy(Object instance) {
        if (instance != null) {
            Class<?> klass = instance.getClass();
            InjectionTarget it = this.beanManager.createInjectionTarget(this.beanManager.createAnnotatedType(klass));
            it.dispose(instance);
        }
    }
}

