/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.config;

import java.util.Dictionary;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.config.ConfigPropertyCommandSupport;

@Command(scope="config", name="propappend", description="Appends the given value to an existing property or creates the property with the specified name and value.")
public class PropAppendCommand
extends ConfigPropertyCommandSupport {
    @Argument(index=0, name="name", description="The name of the property", required=true, multiValued=false)
    String prop;
    @Argument(index=1, name="value", description="The value to append to the property", required=true, multiValued=false)
    String value;

    @Override
    public void propertyAction(Dictionary<String, Object> props) {
        Object currentValue = props.get(this.prop);
        if (currentValue == null) {
            props.put(this.prop, this.value);
        } else if (currentValue instanceof String) {
            props.put(this.prop, currentValue + this.value);
        } else {
            System.err.println("Append Failed: current value is not a String.");
        }
    }
}

