/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.felix.service.command.Function;
import org.apache.karaf.shell.osgi.BundlesCommandOptional;
import org.apache.karaf.shell.osgi.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;

@Command(scope="osgi", name="ls", description="Lists OSGi services.")
public class ListServices
extends BundlesCommandOptional {
    @Option(name="-a", aliases={}, description="Shows all services", required=false, multiValued=false)
    boolean showAll;
    @Option(name="-u", aliases={}, description="Shows services which are in use", required=false, multiValued=false)
    boolean inUse;

    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        if (bundles == null) {
            Bundle[] allBundles = this.getBundleContext().getBundles();
            for (int i = 0; i < allBundles.length; ++i) {
                this.printServicesShort(allBundles[i]);
            }
        } else {
            for (Bundle bundle : bundles) {
                this.printServices(bundle);
            }
        }
    }

    private void printServices(Bundle bundle) {
        boolean headerPrinted = false;
        boolean needSeparator = false;
        ServiceReference[] refs = null;
        refs = this.inUse ? bundle.getServicesInUse() : bundle.getRegisteredServices();
        for (int refIdx = 0; refs != null && refIdx < refs.length; ++refIdx) {
            String[] objectClass = (String[])refs[refIdx].getProperty("objectClass");
            boolean print = true;
            for (int ocIdx = 0; !this.showAll && ocIdx < objectClass.length; ++ocIdx) {
                if (!objectClass[ocIdx].equals(Function.class.getName())) continue;
                print = false;
            }
            if (!headerPrinted) {
                headerPrinted = true;
                String title = Util.getBundleName(bundle);
                title = this.inUse ? title + " uses:" : title + " provides:";
                System.out.println("");
                System.out.println(title);
                System.out.println(Util.getUnderlineString(title));
            }
            if (!this.showAll && !print) continue;
            if (needSeparator) {
                System.out.println("----");
            }
            String[] keys = refs[refIdx].getPropertyKeys();
            for (int keyIdx = 0; keys != null && keyIdx < keys.length; ++keyIdx) {
                Object v = refs[refIdx].getProperty(keys[keyIdx]);
                System.out.println(keys[keyIdx] + " = " + Util.getValueString(v));
            }
            needSeparator = true;
        }
    }

    private void printServicesShort(Bundle bundle) {
        boolean headerPrinted = false;
        ServiceReference[] refs = null;
        refs = this.inUse ? bundle.getServicesInUse() : bundle.getRegisteredServices();
        for (int refIdx = 0; refs != null && refIdx < refs.length; ++refIdx) {
            String[] objectClass = (String[])refs[refIdx].getProperty("objectClass");
            boolean print = true;
            for (int ocIdx = 0; !this.showAll && ocIdx < objectClass.length; ++ocIdx) {
                if (!objectClass[ocIdx].equals(Function.class.getName())) continue;
                print = false;
            }
            if (!this.showAll && !print) continue;
            if (!headerPrinted) {
                headerPrinted = true;
                String title = Util.getBundleName(bundle);
                title = this.inUse ? title + " uses:" : title + " provides:";
                System.out.println("\n" + title);
                System.out.println(Util.getUnderlineString(title));
            }
            System.out.println(Util.getValueString(objectClass));
        }
    }
}

