/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.osgi;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.shell.console.MultiException;
import org.apache.karaf.shell.osgi.BundlesCommand;
import org.osgi.framework.Bundle;

@Command(scope="osgi", name="stop", description="Stop bundle(s).")
public class StopBundle
extends BundlesCommand {
    @Option(name="-t", aliases={"--transient"}, description="Keep the bundle as auto-start", required=false, multiValued=false)
    boolean transientStop;

    @Override
    protected void doExecute(List<Bundle> bundles) throws Exception {
        if (bundles.isEmpty()) {
            System.err.println("No bundles specified.");
            return;
        }
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        for (Bundle bundle : bundles) {
            try {
                if (this.transientStop) {
                    bundle.stop(1);
                    continue;
                }
                bundle.stop();
            }
            catch (Exception e) {
                exceptions.add(new Exception("Unable to stop bundle " + bundle.getBundleId() + (e.getMessage() != null ? ": " + e.getMessage() : ""), e));
            }
        }
        MultiException.throwIf((String)"Error stopping bundles", exceptions);
    }
}

