/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.scr.completer;

import java.util.List;
import org.apache.felix.scr.Component;
import org.apache.felix.scr.ScrService;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.scr.action.ScrActionSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScrCompleterSupport
implements Completer {
    protected final transient Logger logger = LoggerFactory.getLogger(ScrCompleterSupport.class);
    private ScrService scrService;

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        try {
            for (Component component : this.scrService.getComponents()) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Component Name to work on: " + component.getName());
                }
                if (ScrActionSupport.showHiddenComponent(component)) {
                    if (!this.availableComponent(component)) continue;
                    delegate.getStrings().add(component.getName());
                    continue;
                }
                if (ScrActionSupport.isHiddenComponent(component) || !this.availableComponent(component)) continue;
                delegate.getStrings().add(component.getName());
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception completing the command request: " + e.getLocalizedMessage());
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    public abstract boolean availableComponent(Component var1) throws Exception;

    public ScrService getScrService() {
        return this.scrService;
    }

    public void setScrService(ScrService scrService) {
        this.scrService = scrService;
    }
}

