/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.command;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.apache.karaf.features.command.FeaturesCommandSupport;

@Command(scope="features", name="removeUrl", description="Removes the given list of repository URLs from the features service")
public class RemoveUrlCommand
extends FeaturesCommandSupport {
    @Argument(index=0, name="urls", description="One or more repository URLs separated by whitespaces", required=true, multiValued=true)
    List<String> urls;
    @Option(name="-u", aliases={"--uninstall-all"}, description="Uninstall all features contained in the repository URLs", required=false, multiValued=false)
    boolean uninstall;

    protected void doExecute(FeaturesService admin) throws Exception {
        ArrayList<URI> urisToRemove = new ArrayList<URI>();
        for (String url : this.urls) {
            Pattern pattern = Pattern.compile(url);
            for (Repository r : admin.listRepositories()) {
                Matcher matcher = pattern.matcher(r.getURI().toString());
                if (!matcher.matches()) continue;
                urisToRemove.add(r.getURI());
            }
        }
        for (URI uri : urisToRemove) {
            System.out.println("Removing repository URI " + uri);
            try {
                admin.removeRepository(uri, this.uninstall);
            }
            catch (Exception e) {
                System.err.println("Can't remove repository URI " + uri + ": " + e.getMessage());
            }
        }
    }
}

