/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jpm.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Scanner;

public class ScriptUtils {
    private static final boolean windows = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int execute(String name, Map<String, String> props) throws IOException {
        File script = File.createTempFile("jpm.", ".script");
        try {
            if (ScriptUtils.isWindows()) {
                String res = "windows/" + name + ".vbs";
                ScriptUtils.copyFilteredResource(res, script, props);
                int n = ScriptUtils.executeProcess(new ProcessBuilder("cscript", "/NOLOGO", "//E:vbs", script.getCanonicalPath()));
                return n;
            }
            String res = "unix/" + name + ".sh";
            ScriptUtils.copyFilteredResource(res, script, props);
            int n = ScriptUtils.executeProcess(new ProcessBuilder("/bin/sh", script.getCanonicalPath()));
            return n;
        }
        finally {
            script.delete();
        }
    }

    public static int executeProcess(ProcessBuilder builder) throws IOException {
        try {
            Process process = builder.start();
            return process.waitFor();
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFilteredResource(String resource, File outFile, Map<String, String> props) throws IOException {
        InputStream is = null;
        try {
            is = ScriptUtils.class.getResourceAsStream(resource);
            PrintStream out = new PrintStream(new FileOutputStream(outFile));
            try {
                Scanner scanner = new Scanner(is);
                while (scanner.hasNextLine()) {
                    String line = scanner.nextLine();
                    line = ScriptUtils.filter(line, props);
                    out.println(line);
                }
            }
            finally {
                ScriptUtils.safeClose(out);
            }
        }
        finally {
            ScriptUtils.safeClose(is);
        }
    }

    private static void safeClose(InputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void safeClose(OutputStream is) throws IOException {
        if (is == null) {
            return;
        }
        try {
            is.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static String filter(String line, Map<String, String> props) {
        for (Map.Entry<String, String> i : props.entrySet()) {
            int p1 = line.indexOf(i.getKey());
            if (p1 < 0) continue;
            String l1 = line.substring(0, p1);
            String l2 = line.substring(p1 + i.getKey().length());
            line = l1 + i.getValue() + l2;
        }
        return line;
    }

    public static boolean isWindows() {
        return windows;
    }
}

