/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.deployer.kar;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.felix.fileinstall.ArtifactInstaller;
import org.apache.karaf.features.Feature;
import org.apache.karaf.features.FeaturesService;
import org.apache.karaf.features.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class KarArtifactInstaller
implements ArtifactInstaller {
    public static final String FEATURES_CLASSIFIER = "features";
    private final Logger logger = LoggerFactory.getLogger(KarArtifactInstaller.class);
    private static final String KAR_SUFFIX = ".kar";
    private static final String ZIP_SUFFIX = ".zip";
    private String base = "./";
    private String localRepoPath = "./target/system";
    private String timestampPath;
    private DocumentBuilderFactory dbf;
    private FeaturesService featuresService;
    private boolean noAutoRefreshBundles;

    public void init() {
        this.dbf = DocumentBuilderFactory.newInstance();
        this.dbf.setNamespaceAware(true);
        this.timestampPath = this.localRepoPath + File.separator + ".timestamps";
        File timestampFile = new File(this.timestampPath);
        if (!timestampFile.exists() && !timestampFile.mkdirs()) {
            this.logger.warn("Unable to create directory for Karaf Archive timestamps. Results may vary...");
        }
        this.logger.info("Karaf archives will be extracted to {}", (Object)this.localRepoPath);
        this.logger.info("Timestamps for Karaf archives will be extracted to {}", (Object)this.timestampPath);
    }

    public void destroy() {
        this.logger.info("Karaf archive installer destroyed.");
    }

    public void install(File file) throws Exception {
        if (this.alreadyExtracted(file)) {
            this.logger.info("Ignoring '{}'; timestamp indicates it's already been deployed.", (Object)file);
            return;
        }
        this.logger.info("Installing KAR file {}", (Object)file);
        File karFile = new File(this.localRepoPath, file.getName());
        this.copy(file.toURI(), karFile);
        ZipFile zipFile = null;
        ArrayList<URI> featuresRepositoriesInKar = new ArrayList<URI>();
        try {
            zipFile = new ZipFile(karFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                File extract;
                ZipEntry entry = entries.nextElement();
                String repoEntryName = this.getRepoEntryName(entry);
                if (repoEntryName != null && this.isFeaturesRepository(extract = this.extract(zipFile, entry, repoEntryName, this.localRepoPath))) {
                    this.addToFeaturesRepositories(extract.toURI());
                    featuresRepositoriesInKar.add(extract.toURI());
                }
                if (!entry.getName().startsWith("resource")) continue;
                String resourceEntryName = entry.getName().substring("resource/".length());
                this.extract(zipFile, entry, resourceEntryName, this.base);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
        this.installFeatures(featuresRepositoriesInKar);
        this.updateTimestamp(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copy(URI url, File file) throws Exception {
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            is = url.toURL().openStream();
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            int count = is.read(buffer);
            while (count >= 0) {
                fos.write(buffer, 0, count);
                count = is.read(buffer);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (fos != null) {
                try {
                    fos.flush();
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void installFeatures(List<URI> featuresRepositories) {
        for (Repository repository : this.featuresService.listRepositories()) {
            for (URI karFeatureRepoUri : featuresRepositories) {
                if (!repository.getURI().equals(karFeatureRepoUri)) continue;
                try {
                    for (Feature feature : repository.getFeatures()) {
                        try {
                            this.logger.debug("noAutoRefreshBundles is " + this.isNoAutoRefreshBundles());
                            if (this.isNoAutoRefreshBundles()) {
                                this.featuresService.installFeature(feature, EnumSet.of(FeaturesService.Option.NoAutoRefreshBundles));
                                continue;
                            }
                            this.featuresService.installFeature(feature, EnumSet.noneOf(FeaturesService.Option.class));
                        }
                        catch (Exception e) {
                            this.logger.warn("Unable to install Kar feature {}", (Object)(feature.getName() + "/" + feature.getVersion()), (Object)e);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Can't get features for KAR {}", (Object)karFeatureRepoUri, (Object)e);
                }
            }
        }
    }

    private void uninstallFeatures(List<URI> featuresRepositories) {
        for (Repository repository : this.featuresService.listRepositories()) {
            for (URI karFeatureRepoUri : featuresRepositories) {
                if (!repository.getURI().equals(karFeatureRepoUri)) continue;
                try {
                    for (Feature feature : repository.getFeatures()) {
                        try {
                            this.featuresService.uninstallFeature(feature.getName(), feature.getVersion());
                        }
                        catch (Exception e) {
                            this.logger.warn("Unable to uninstall Kar feature {}", (Object)(feature.getName() + "/" + feature.getVersion()), (Object)e);
                        }
                    }
                }
                catch (Exception e) {
                    this.logger.warn("Can't get features for KAR {}", (Object)karFeatureRepoUri, (Object)e);
                }
            }
        }
    }

    private File extract(ZipFile zipFile, ZipEntry entry, String repoEntryName, String base) throws IOException {
        File extract;
        if (entry.isDirectory()) {
            extract = new File(base + File.separator + repoEntryName);
            this.logger.debug("Creating directory '{}'", (Object)extract.getName());
            extract.mkdirs();
        } else {
            extract = new File(base + File.separator + repoEntryName);
            extract.getParentFile().mkdirs();
            InputStream in = null;
            FileOutputStream out = null;
            try {
                in = zipFile.getInputStream(entry);
                out = new FileOutputStream(extract);
                byte[] buffer = new byte[8192];
                int count = in.read(buffer);
                int totalBytes = 0;
                while (count >= 0) {
                    out.write(buffer, 0, count);
                    totalBytes += count;
                    count = in.read(buffer);
                }
                this.logger.debug("Extracted {} bytes to {}", (Object)totalBytes, (Object)extract);
            }
            catch (IOException ioException) {
                throw ioException;
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception exception) {}
                }
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return extract;
    }

    private String getRepoEntryName(ZipEntry entry) {
        String entryName = entry.getName();
        if (entryName.startsWith("repository")) {
            return entryName.substring("repository/".length());
        }
        if (entryName.startsWith("META-INF") || entryName.startsWith("resources")) {
            return null;
        }
        return entryName;
    }

    public void uninstall(File file) throws Exception {
        this.logger.debug("Looking for KAR entries to purge the local repository");
        File karFile = new File(this.localRepoPath, file.getName());
        ArrayList<URI> featuresRepositories = new ArrayList<URI>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(karFile);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String repoEntryName = this.getRepoEntryName(entry);
                if (repoEntryName != null) {
                    File toDelete = new File(this.localRepoPath + File.separator + repoEntryName);
                    if (this.isFeaturesRepository(toDelete)) {
                        featuresRepositories.add(toDelete.toURI());
                    } else if (toDelete.isFile() && toDelete.exists()) {
                        toDelete.delete();
                    }
                }
                if (!entry.getName().startsWith("resource")) continue;
                String resourceEntryName = entry.getName().substring("resource/".length());
                File toDelete = new File(this.base + File.separator + resourceEntryName);
                if (!toDelete.isFile() || !toDelete.exists()) continue;
                toDelete.delete();
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (Exception exception) {}
            }
        }
        this.uninstallFeatures(featuresRepositories);
        for (URI featuresRepository : featuresRepositories) {
            this.featuresService.removeRepository(featuresRepository);
            File toDelete = new File(featuresRepository);
            if (!toDelete.exists() || !toDelete.isFile()) continue;
            toDelete.delete();
        }
        karFile.delete();
        File timestamp = this.getArchiveTimestampFile(file);
        if (timestamp.exists()) {
            this.logger.debug("Removing the timestamp file");
            timestamp.delete();
        }
    }

    public void update(File file) throws Exception {
        this.logger.warn("Karaf archive '{}' has been updated; redeploying.", (Object)file);
        this.uninstall(file);
        this.install(file);
    }

    protected void updateTimestamp(File karafArchive) throws Exception {
        File timestamp = this.getArchiveTimestampFile(karafArchive);
        if (timestamp.exists()) {
            this.logger.debug("Deleting old timestamp file '{}'", (Object)timestamp);
            if (!timestamp.delete()) {
                throw new Exception("Unable to delete archive timestamp '" + timestamp + "'");
            }
        }
        this.logger.debug("Creating timestamp file '{}'", (Object)timestamp);
        timestamp.createNewFile();
    }

    protected boolean alreadyExtracted(File karafArchive) {
        File timestamp = this.getArchiveTimestampFile(karafArchive);
        if (timestamp.exists()) {
            return timestamp.lastModified() >= karafArchive.lastModified();
        }
        return false;
    }

    protected File getArchiveTimestampFile(File karafArchive) {
        File timestampDir = new File(new File(this.localRepoPath), ".timestamps");
        if (!timestampDir.exists()) {
            timestampDir.mkdirs();
        }
        return new File(timestampDir, karafArchive.getName());
    }

    protected boolean isFeaturesRepository(File artifact) {
        try {
            if (artifact.isFile() && artifact.getName().endsWith(".xml")) {
                Document doc = this.parse(artifact);
                String name = doc.getDocumentElement().getLocalName();
                String uri = doc.getDocumentElement().getNamespaceURI();
                if (FEATURES_CLASSIFIER.equals(name) && (uri == null || "".equals(uri) || uri.startsWith("http://karaf.apache.org/xmlns/features/v"))) {
                    return true;
                }
            }
        }
        catch (Exception e) {
            this.logger.debug("File '{}' is not a features file.", (Object)artifact.getName(), (Object)e);
        }
        return false;
    }

    protected Document parse(File artifact) throws Exception {
        DocumentBuilder db = this.dbf.newDocumentBuilder();
        db.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) throws SAXException {
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }
        });
        return db.parse(artifact);
    }

    private void addToFeaturesRepositories(URI uri) {
        try {
            this.featuresService.removeRepository(uri);
            this.featuresService.addRepository(uri);
            this.logger.info("Added feature repository '{}'.", (Object)uri);
        }
        catch (Exception e) {
            this.logger.warn("Unable to add repository '{}'", (Object)uri, (Object)e);
        }
    }

    static URI pathToMvnUri(String path) {
        String[] bits = path.split("/");
        String classifier = FEATURES_CLASSIFIER;
        String artifactType = "xml";
        String version = bits[bits.length - 2];
        String artifactId = bits[bits.length - 3];
        StringBuilder buf = new StringBuilder("mvn:");
        for (int i = 0; i < bits.length - 3; ++i) {
            buf.append(bits[i]);
            if (i >= bits.length - 4) continue;
            buf.append(".");
        }
        buf.append("/").append(artifactId).append("/").append(version).append("/").append(artifactType).append("/").append(classifier);
        URI mvnUri = URI.create(buf.toString());
        return mvnUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean canHandle(File file) {
        if (file.isFile() && file.getName().endsWith(KAR_SUFFIX)) {
            this.logger.info("Found a .kar file to deploy.");
            return true;
        }
        if (file.isFile() && file.getName().endsWith(ZIP_SUFFIX)) {
            this.logger.debug("Found a .zip file to deploy; checking contents to see if it's a Karaf archive.");
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(file);
                if (zipFile.getEntry("META-INF/KARAF.MF") != null) {
                    this.logger.info("Found a Karaf archive with .zip prefix; will deploy.");
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                this.logger.warn("Problem extracting zip file '{}'; ignoring.", (Object)file.getName(), (Object)e);
            }
            finally {
                try {
                    if (zipFile != null) {
                        zipFile.close();
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Problem closing zip file '{}'; ignoring.", (Object)file.getName(), (Object)e);
                }
            }
        }
        return false;
    }

    public boolean deleteLocalRepository() {
        return this.deleteDirectory(new File(this.localRepoPath));
    }

    private boolean deleteDirectory(File path) {
        if (path.exists()) {
            File[] files = path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    this.deleteDirectory(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return path.delete();
    }

    public void setBasePath(String base) {
        this.base = base;
    }

    public void setLocalRepoPath(String localRepoPath) {
        this.localRepoPath = localRepoPath;
    }

    public void setFeaturesService(FeaturesService featuresService) {
        this.featuresService = featuresService;
    }

    public boolean isNoAutoRefreshBundles() {
        return this.noAutoRefreshBundles;
    }

    public void setNoAutoRefreshBundles(boolean noAutoRefreshBundles) {
        this.noAutoRefreshBundles = noAutoRefreshBundles;
    }
}

