/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.command;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jms.command.JmsCommandSupport;

@Command(scope="jms", name="count", description="Count the number of messages on a JMS queue.")
public class CountCommand
extends JmsCommandSupport {
    @Argument(index=0, name="connectionFactory", description="The JMS connection factory name", required=true, multiValued=false)
    String connectionFactory;
    @Argument(index=1, name="queue", description="The JMS queue name", required=true, multiValued=false)
    String queue;
    @Option(name="-u", aliases={"--username"}, description="Username to connect to the JMS broker", required=false, multiValued=false)
    String username = "karaf";
    @Option(name="-p", aliases={"--password"}, description="Password to connect to the JMS broker", required=false, multiValued=false)
    String password = "karaf";

    @Override
    public Object doExecute() throws Exception {
        System.out.println("Messages Count");
        System.out.println(this.getJmsService().count(this.connectionFactory, this.queue, this.username, this.password));
        return null;
    }
}

