/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jms.command;

import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.apache.karaf.jms.command.JmsCommandSupport;

@Command(scope="jms", name="topics", description="List the JMS topics.")
public class TopicsCommand
extends JmsCommandSupport {
    @Argument(index=0, name="connectionFactory", description="The JMS connection factory name", required=true, multiValued=false)
    String connectionFactory;
    @Option(name="-u", aliases={"--username"}, description="Username to connect to the JMS broker", required=false, multiValued=false)
    String username = "karaf";
    @Option(name="-p", aliases={"--password"}, description="Password to connect to the JMS broker", required=false, multiValued=false)
    String password = "karaf";

    @Override
    public Object doExecute() throws Exception {
        System.out.println("JMS Topics");
        for (String topic : this.getJmsService().topics(this.connectionFactory, this.username, this.password)) {
            System.out.println(topic);
        }
        return null;
    }
}

