/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command;

import java.util.Map;
import java.util.Set;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;

@Command(scope="jdbc", name="datasources", description="List the JDBC datasources")
public class DataSourcesCommand
extends JdbcCommandSupport {
    private static final String JDBC_DATASOURCES_STRING_FORMAT = "%20s %15s %10s %45s %5s";

    @Override
    public Object doExecute() throws Exception {
        System.out.println(String.format(JDBC_DATASOURCES_STRING_FORMAT, "Name", "Product", "Version", "URL", "Status"));
        Map datasources = this.getJdbcService().aliases();
        for (Map.Entry entry : datasources.entrySet()) {
            StringBuilder ids = new StringBuilder();
            for (String id : (Set)entry.getValue()) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(id);
            }
            String id = ids.toString();
            try {
                Map info = this.getJdbcService().info((String)entry.getKey());
                System.out.println(String.format(JDBC_DATASOURCES_STRING_FORMAT, id, info.get("db.product"), info.get("db.version"), info.get("url"), "OK"));
            }
            catch (Exception e) {
                System.out.println(String.format(JDBC_DATASOURCES_STRING_FORMAT, id, "", "", "", "Error"));
            }
        }
        return null;
    }
}

