/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jdbc.command;

import java.util.List;
import java.util.Map;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.jdbc.command.JdbcCommandSupport;

@Command(scope="jdbc", name="query", description="Execute a SQL query on a JDBC datasource")
public class QueryCommand
extends JdbcCommandSupport {
    @Argument(index=0, name="datasource", description="The JDBC datasource to use", required=true, multiValued=false)
    String datasource;
    @Argument(index=1, name="query", description="The SQL query to execute", required=true, multiValued=false)
    String query;

    @Override
    public Object doExecute() throws Exception {
        Map map = this.getJdbcService().query(this.datasource, this.query);
        int rowCount = 0;
        for (String column : map.keySet()) {
            System.out.print(column + "\t");
            rowCount = ((List)map.get(column)).size();
        }
        System.out.println("");
        for (int i = 0; i < rowCount; ++i) {
            for (String column : map.keySet()) {
                System.out.print((String)((List)map.get(column)).get(i) + "\t");
            }
            System.out.println("");
        }
        return null;
    }
}

