/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.web.weld.impl;

import javax.el.ELContextListener;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.jboss.weld.el.WeldELContextListener;
import org.jboss.weld.manager.api.WeldManager;
import org.jboss.weld.servlet.WeldListener;
import org.jboss.weld.servlet.api.ServletListener;
import org.jboss.weld.servlet.api.helpers.ForwardingServletListener;
import org.ops4j.pax.cdi.spi.CdiContainer;
import org.ops4j.pax.cdi.spi.Injector;
import org.ops4j.pax.cdi.web.weld.impl.JettyDecorator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeldServletContextListener
extends ForwardingServletListener {
    private static Logger log = LoggerFactory.getLogger(WeldServletContextListener.class);
    private ServletListener weldListener = new WeldListener();
    private CdiContainer cdiContainer;

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext context = sce.getServletContext();
        this.cdiContainer = (CdiContainer)context.getAttribute("org.ops4j.pax.cdi.container");
        this.cdiContainer.start((Object)context);
        WeldManager manager = (WeldManager)this.cdiContainer.unwrap(WeldManager.class);
        Injector injector = new Injector((BeanManager)manager);
        context.setAttribute("org.ops4j.pax.cdi.injector", (Object)injector);
        JettyDecorator.process(context);
        log.info("registered Jetty decorator for JSR-299 injection");
        JspFactory jspFactory = JspFactory.getDefaultFactory();
        if (jspFactory != null) {
            JspApplicationContext jspApplicationContext = jspFactory.getJspApplicationContext(context);
            jspApplicationContext.addELResolver(manager.getELResolver());
            jspApplicationContext.addELContextListener((ELContextListener)new WeldELContextListener());
        }
        super.contextInitialized(sce);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.cdiContainer.stop();
        sce.getServletContext().removeAttribute("org.ops4j.pax.cdi.injector");
        super.contextDestroyed(sce);
    }

    protected ServletListener delegate() {
        return this.weldListener;
    }
}

