/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.service.internal.util.SupportUtils;
import org.ops4j.pax.web.service.spi.Configuration;
import org.ops4j.util.property.PropertyResolver;
import org.ops4j.util.property.PropertyStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationImpl
extends PropertyStore
implements Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurationImpl.class);
    private final PropertyResolver propertyResolver;

    public ConfigurationImpl(PropertyResolver propertyResolver) {
        NullArgumentException.validateNotNull(propertyResolver, "Property resolver");
        this.propertyResolver = propertyResolver;
    }

    @Override
    public Integer getHttpPort() {
        return this.getResolvedIntegerProperty("org.osgi.service.http.port");
    }

    @Override
    public String getHttpConnectorName() {
        return this.getResolvedStringProperty("org.osgi.service.http.connector.name");
    }

    @Override
    public Boolean useNIO() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.useNIO");
    }

    @Override
    public Boolean checkForwardedHeaders() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.checkForwardedHeaders");
    }

    @Override
    public Boolean isClientAuthNeeded() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.ssl.clientauthneeded");
    }

    @Override
    public Boolean isClientAuthWanted() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.ssl.clientauthwanted");
    }

    @Override
    public Boolean isHttpEnabled() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.enabled");
    }

    @Override
    public Integer getHttpSecurePort() {
        return this.getResolvedIntegerProperty("org.osgi.service.http.port.secure");
    }

    @Override
    public String getHttpSecureConnectorName() {
        return this.getResolvedStringProperty("org.osgi.service.http.secure.connector.name");
    }

    @Override
    public Boolean isHttpSecureEnabled() {
        return this.getResolvedBooleanProperty("org.osgi.service.http.secure.enabled");
    }

    @Override
    public String getSslKeystore() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.keystore");
    }

    @Override
    public String getSslKeystoreType() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.keystore.type");
    }

    @Override
    public String getSslKeystorePassword() {
        String keystorePassword = this.getResolvedStringProperty("org.ops4j.pax.web.ssl.keystore.password");
        if (null == keystorePassword || "".equals(keystorePassword)) {
            keystorePassword = this.getResolvedStringProperty("org.ops4j.pax.web.ssl.password");
        }
        return keystorePassword;
    }

    @Override
    public String getSslPassword() {
        return this.getSslKeystorePassword();
    }

    @Override
    public String getSslKeyAlias() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.key.alias");
    }

    @Override
    public String getSslKeyPassword() {
        String privateKeyPassword = this.getResolvedStringProperty("org.ops4j.pax.web.ssl.key.password");
        if (null == privateKeyPassword || "".equals(privateKeyPassword)) {
            privateKeyPassword = this.getResolvedStringProperty("org.ops4j.pax.web.ssl.keypassword");
        }
        return privateKeyPassword;
    }

    @Override
    public String getTrustStore() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.truststore");
    }

    @Override
    public String getTrustStorePassword() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.truststore.password");
    }

    @Override
    public String getTrustStoreType() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.ssl.truststore.type");
    }

    @Override
    public List<String> getCiphersuiteIncluded() {
        String cipherIncludeString = this.getResolvedStringProperty("org.ops4j.pax.web.ssl.ciphersuites.included");
        if (cipherIncludeString == null) {
            return Collections.emptyList();
        }
        String[] split = cipherIncludeString.split(",");
        return Arrays.asList(split);
    }

    @Override
    public List<String> getCiphersuiteExcluded() {
        String cipherExcludeString = this.getResolvedStringProperty("org.ops4j.pax.web.ssl.ciphersuites.excluded");
        if (cipherExcludeString == null) {
            return Collections.emptyList();
        }
        String[] split = cipherExcludeString.split(",");
        return Arrays.asList(split);
    }

    @Override
    public List<String> getProtocolsIncluded() {
        String protocolsIncludedString = this.getResolvedStringProperty("org.ops4j.pax.web.ssl.protocols.included");
        if (protocolsIncludedString == null) {
            return Collections.emptyList();
        }
        String[] split = protocolsIncludedString.split(",");
        return Arrays.asList(split);
    }

    @Override
    public List<String> getProtocolsExcluded() {
        String protocolsExcludedString = this.getResolvedStringProperty("org.ops4j.pax.web.ssl.protocols.excluded");
        if (protocolsExcludedString == null) {
            return Collections.emptyList();
        }
        String[] split = protocolsExcludedString.split(",");
        return Arrays.asList(split);
    }

    @Override
    public File getTemporaryDirectory() {
        try {
            if (!this.contains("javax.servlet.context.tempdir")) {
                String tempDirPath = this.propertyResolver.get("javax.servlet.context.tempdir");
                File tempDir = null;
                if (tempDirPath != null && !(tempDir = tempDirPath.startsWith("file:") ? new File(new URI(tempDirPath)) : new File(tempDirPath)).exists()) {
                    tempDir.mkdirs();
                }
                return this.set("javax.servlet.context.tempdir", tempDir);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property javax.servlet.context.tempdir has failed");
        }
        return (File)this.get("javax.servlet.context.tempdir");
    }

    @Override
    public File getConfigurationDir() {
        try {
            if (!this.contains("org.ops4j.pax.web.config.file")) {
                String serverConfigurationFileName = this.propertyResolver.get("org.ops4j.pax.web.config.file");
                File configurationFile = serverConfigurationFileName.startsWith("file:") ? new File(new URI(serverConfigurationFileName)) : new File(serverConfigurationFileName);
                if (!configurationFile.exists()) {
                    LOG.debug("Reading from configured path for the configuration property org.ops4j.pax.web.config.file has failed");
                }
                return this.set("org.ops4j.pax.web.config.file", configurationFile);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property org.ops4j.pax.web.config.file has failed");
        }
        return null;
    }

    @Override
    public URL getConfigurationURL() {
        try {
            if (!this.contains("org.ops4j.pax.web.config.url")) {
                String serverConfigurationURL = this.propertyResolver.get("org.ops4j.pax.web.config.url");
                URL configurationURL = new URL(serverConfigurationURL);
                return this.set("org.ops4j.pax.web.config.url", configurationURL);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property org.ops4j.pax.web.config.url has failed");
        }
        return null;
    }

    @Override
    public Integer getSessionTimeout() {
        return this.getResolvedIntegerProperty("org.ops4j.pax.web.session.timeout");
    }

    @Override
    public String getSessionCookie() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.cookie");
    }

    @Override
    public String getSessionDomain() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.domain");
    }

    @Override
    public String getSessionPath() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.path");
    }

    @Override
    public String getSessionUrl() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.url");
    }

    @Override
    public Boolean getSessionCookieHttpOnly() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.session.cookie.httpOnly");
    }

    @Override
    public Boolean getSessionLazyLoad() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.session.lazyload");
    }

    @Override
    public String getSessionStoreDirectory() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.session.storedirectory");
    }

    @Override
    public String getWorkerName() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.worker.name");
    }

    @Override
    public String[] getListeningAddresses() {
        try {
            if (!this.contains("org.ops4j.pax.web.listening.addresses")) {
                String interfacesString = this.propertyResolver.get("org.ops4j.pax.web.listening.addresses");
                String[] interfaces = interfacesString == null ? new String[]{} : interfacesString.split(",");
                return this.set("org.ops4j.pax.web.listening.addresses", interfaces);
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property org.ops4j.pax.web.listening.addresses has failed");
        }
        return (String[])this.get("org.ops4j.pax.web.listening.addresses");
    }

    @Override
    public String getJspScratchDir() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.scratch.dir");
    }

    @Override
    public Integer getJspCheckInterval() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedIntegerProperty("org.ops4j.pax.web.jsp.check.interval");
    }

    @Override
    public Boolean getJspClassDebugInfo() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.debug.info");
    }

    @Override
    public Boolean getJspDevelopment() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.development");
    }

    @Override
    public Boolean getJspEnablePooling() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.enable.pooling");
    }

    @Override
    public String getJspIeClassId() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.ie.classid");
    }

    @Override
    public String getJspJavaEncoding() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.java.encoding");
    }

    @Override
    public Boolean getJspKeepgenerated() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.keep.generated");
    }

    @Override
    public String getJspLogVerbosityLevel() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedStringProperty("org.ops4j.pax.web.jsp.log.verbosity.level");
    }

    @Override
    public Boolean getJspMappedfile() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.mapped.file");
    }

    @Override
    public Integer getJspTagpoolMaxSize() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedIntegerProperty("org.ops4j.pax.web.jsp.tagpool.max.size");
    }

    @Override
    public Boolean getJspPrecompilation() {
        if (!SupportUtils.isJSPAvailable()) {
            return null;
        }
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.jsp.precompilation");
    }

    @Override
    public Boolean isLogNCSAFormatEnabled() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.enabled");
    }

    @Override
    public String getLogNCSAFormat() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.format");
    }

    @Override
    public String getLogNCSARetainDays() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.retaindays");
    }

    @Override
    public Boolean isLogNCSAAppend() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.append");
    }

    @Override
    public Boolean isLogNCSAExtended() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.extended");
    }

    @Override
    public Boolean isLogNCSADispatch() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.dispatch");
    }

    @Override
    public String getLogNCSATimeZone() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.logtimezone");
    }

    @Override
    public String getLogNCSADirectory() {
        return this.getResolvedStringProperty("org.ops4j.pax.web.log.ncsa.directory");
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "http enabled=" + this.isHttpEnabled() + ",http port=" + this.getHttpPort() + ",http secure enabled=" + this.isHttpSecureEnabled() + ",http secure port=" + this.getHttpSecurePort() + ",ssl keystore=" + this.getSslKeystore() + ",ssl keystoreType=" + this.getSslKeystoreType() + ",session timeout=" + this.getSessionTimeout() + ",session url=" + this.getSessionUrl() + ",session cookie=" + this.getSessionCookie() + ",session cookie httpOnly=" + this.getSessionCookieHttpOnly() + ",worker name=" + this.getWorkerName() + ",listening addresses=" + Arrays.toString(this.getListeningAddresses()) + "}";
    }

    private String getResolvedStringProperty(String property) {
        try {
            if (!this.contains(property)) {
                return this.set(property, this.propertyResolver.get(property));
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property " + property + " has failed");
        }
        return (String)this.get(property);
    }

    private Boolean getResolvedBooleanProperty(String property) {
        try {
            if (!this.contains(property)) {
                String resolvedProperty = this.propertyResolver.get(property);
                return this.set(property, resolvedProperty == null ? null : Boolean.valueOf(resolvedProperty));
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property " + property + " has failed");
        }
        return (Boolean)this.get(property);
    }

    private Integer getResolvedIntegerProperty(String property) {
        try {
            if (!this.contains(property)) {
                String resolvedProperty = this.propertyResolver.get(property);
                return this.set(property, resolvedProperty == null ? null : Integer.valueOf(this.propertyResolver.get(property)));
            }
        }
        catch (Exception ignore) {
            LOG.debug("Reading configuration property " + property + " has failed");
        }
        return (Integer)this.get(property);
    }

    @Override
    public List<String> getVirtualHosts() {
        LinkedList<String> virtualHosts = new LinkedList<String>();
        String virtualHostListString = this.getResolvedStringProperty("org.ops4j.pax.web.default.virtualhosts");
        if (virtualHostListString != null && virtualHostListString.length() > 0) {
            String[] virtualHostArray;
            for (String virtualHost : virtualHostArray = virtualHostListString.split(",")) {
                virtualHosts.add(virtualHost.trim());
            }
        }
        return virtualHosts;
    }

    @Override
    public List<String> getConnectors() {
        LinkedList<String> connectors = new LinkedList<String>();
        String connectorListString = this.getResolvedStringProperty("org.ops4j.pax.web.default.connectors");
        if (connectorListString != null && connectorListString.length() > 0) {
            String[] connectorArray;
            for (String connector : connectorArray = connectorListString.split(",")) {
                connectors.add(connector.trim());
            }
        }
        return connectors;
    }

    @Override
    public Boolean isLogNCSALatency() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.latency");
    }

    @Override
    public Boolean isLogNCSACookies() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.cookies");
    }

    @Override
    public Boolean isLogNCSAServer() {
        return this.getResolvedBooleanProperty("org.ops4j.pax.web.log.ncsa.server");
    }
}

