/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.shell.obr;

import java.util.List;
import org.apache.felix.bundlerepository.RepositoryAdmin;
import org.apache.felix.bundlerepository.Resource;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.karaf.shell.obr.ObrCommandSupport;
import org.osgi.framework.Version;

@Command(scope="obr", name="list", description="Lists OBR bundles, optionally providing the given packages.")
public class ListCommand
extends ObrCommandSupport {
    @Argument(index=0, name="packages", description="A list of packages separated by whitespaces.", required=false, multiValued=true)
    List<String> packages;

    @Override
    protected void doExecute(RepositoryAdmin admin) throws Exception {
        String substr = null;
        if (this.packages != null) {
            for (String arg : this.packages) {
                substr = substr == null ? "" : substr + " ";
                substr = substr + arg;
            }
        }
        StringBuffer sb = new StringBuffer();
        if (substr == null || substr.length() == 0) {
            sb.append("(|(presentationname=*)(symbolicname=*))");
        } else {
            sb.append("(|(presentationname=*");
            sb.append(substr);
            sb.append("*)(symbolicname=*");
            sb.append(substr);
            sb.append("*))");
        }
        Resource[] resources = admin.discoverResources(sb.toString());
        for (int resIdx = 0; resources != null && resIdx < resources.length; ++resIdx) {
            String name = resources[resIdx].getPresentationName();
            String bundleSymbolicName = resources[resIdx].getSymbolicName();
            Version version = resources[resIdx].getVersion();
            StringBuffer outputString = new StringBuffer();
            if (bundleSymbolicName != null) {
                outputString.append(bundleSymbolicName);
                outputString.append(" - ");
            }
            if (name != null) {
                outputString.append(name);
                outputString.append(" ");
            }
            if (version != null) {
                outputString.append("(");
                outputString.append(version);
                outputString.append(")");
            }
            System.out.println(outputString.toString());
        }
        if (resources == null) {
            System.out.println("No matching bundles.");
        }
    }
}

