/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.modules.audit;

import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.karaf.jaas.boot.principal.UserPrincipal;

public abstract class AbstractAuditLoginModule
implements LoginModule {
    protected Subject subject;
    private CallbackHandler handler;
    private String username;
    private boolean enabled;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.enabled = Boolean.parseBoolean((String)options.get("enabled"));
        this.handler = callbackHandler;
    }

    protected abstract void audit(Action var1, String var2);

    @Override
    public boolean login() throws LoginException {
        NameCallback user = new NameCallback("User name:");
        Callback[] callbacks = new Callback[]{user};
        try {
            this.handler.handle(callbacks);
        }
        catch (Exception e) {
            throw (LoginException)new LoginException("Unable to process callback: " + e.getMessage()).initCause(e);
        }
        if (callbacks.length != 1) {
            throw new IllegalStateException("Number of callbacks changed by server!");
        }
        user = (NameCallback)callbacks[0];
        this.username = user.getName();
        if (this.enabled && this.username != null) {
            this.audit(Action.ATTEMPT, this.username);
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        String username = this.getUsername();
        if (this.enabled && username != null) {
            this.audit(Action.SUCCESS, username);
        }
        return false;
    }

    @Override
    public boolean abort() throws LoginException {
        String username = this.getUsername();
        if (this.enabled && username != null) {
            this.audit(Action.FAILURE, username);
            username = null;
        }
        return false;
    }

    @Override
    public boolean logout() throws LoginException {
        String username = this.getUsername();
        if (this.enabled && username != null) {
            this.audit(Action.LOGOUT, username);
            username = null;
        }
        return false;
    }

    public String getUsername() {
        if (this.username != null) {
            return this.username;
        }
        if (this.subject.getPrincipals(UserPrincipal.class).iterator().hasNext()) {
            UserPrincipal principal = this.subject.getPrincipals(UserPrincipal.class).iterator().next();
            return principal.getName();
        }
        return null;
    }

    static enum Action {
        ATTEMPT,
        SUCCESS,
        FAILURE,
        LOGOUT;

    }
}

