/*
* JBoss, Home of Professional Open Source
* Copyright 2006, JBoss Inc., and individual contributors as indicated
* by the @authors tag. See the copyright.txt in the distribution for a
* full listing of individual contributors.
*
* This is free software; you can redistribute it and/or modify it
* under the terms of the GNU Lesser General Public License as
* published by the Free Software Foundation; either version 2.1 of
* the License, or (at your option) any later version.
*
* This software is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this software; if not, write to the Free
* Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
* 02110-1301 USA, or see the FSF site: http://www.fsf.org.
*/
package org.jboss.scanning.deployers.filter;

import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.helpers.VFS2BaseBridgeDeploymentUnitFilter;
import org.jboss.scanning.plugins.filter.ScanningMetaDataRecurseFilter;
import org.jboss.scanning.plugins.filter.ScanningMetaDataResourceFilter;
import org.jboss.scanning.plugins.helpers.DelegateResourceFilter;
import org.jboss.scanning.spi.metadata.ScanningMetaData;

/**
 * ScanningMetaDataResourceFilter
 *
 * @author <a href="mailto:ales.justin@jboss.com">Ales Justin</a>
 */
public class ScanningDeploymentUnitFilter extends VFS2BaseBridgeDeploymentUnitFilter
{
   protected boolean doAccepts(DeploymentUnit unit)
   {
      ScanningMetaData smd = unit.getAttachment(ScanningMetaData.class);
      if (smd != null)
      {
         // recurse
         ResourceFilter recurse = createRecurseFilter(smd);
         if (recurse != null)
         {
            ResourceFilter previousRecurse = unit.getAttachment(ResourceFilter.class.getName() + ".recurse", ResourceFilter.class);
            if (previousRecurse != null)
               recurse = new DelegateResourceFilter(previousRecurse, recurse);

            unit.addAttachment(ResourceFilter.class.getName() + ".recurse", recurse, ResourceFilter.class);
         }

         // resource
         ResourceFilter filter = createResourceFilter(smd);
         if (filter != null)
         {
            ResourceFilter previousFilter = unit.getAttachment(ResourceFilter.class.getName() + ".resource", ResourceFilter.class);
            if (previousFilter != null)
               filter = new DelegateResourceFilter(previousFilter, filter);

            unit.addAttachment(ResourceFilter.class.getName() + ".resource", filter, ResourceFilter.class);
         }
      }
      return true;
   }

   /**
    * Create recurse filter.
    *
    * @param smd the scanning metadata
    * @return recurse filter
    */
   protected ResourceFilter createRecurseFilter(ScanningMetaData smd)
   {
      return new ScanningMetaDataRecurseFilter(smd);
   }

   /**
    * Create resource filter.
    *
    * @param smd the scanning metadata
    * @return resource filter
    */
   protected ResourceFilter createResourceFilter(ScanningMetaData smd)
   {
      return new ScanningMetaDataResourceFilter(smd);
   }
}
