/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control.example.jaxrs.entity;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.jboss.seam.exception.control.example.jaxrs.entity.Author;

@Entity
@XmlRootElement
@NamedQueries(value={@NamedQuery(name="booksById", query="select b from Book b where b.id = :id"), @NamedQuery(name="books", query="select b from Book b")})
public class Book {
    private Long id;
    private String title;
    private List<Author> authors;

    public void addAuthor(Author newAuthor) {
        if (this.authors == null) {
            this.authors = new ArrayList();
        }
        this.authors.add(newAuthor);
    }

    @ManyToMany
    public List<Author> getAuthors() {
        return this.authors;
    }

    public void setAuthors(List<Author> authors) {
        this.authors = authors;
    }

    @XmlAttribute
    @GeneratedValue
    @Id
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @NotNull
    @Size(min=1, max=100)
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }
}

