/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control.example.jaxrs.resource;

import java.security.AccessControlException;
import java.util.List;
import javax.ejb.Stateless;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jboss.seam.exception.control.example.jaxrs.entity.Book;
import org.jboss.seam.rest.validation.ValidateRequest;

@Produces(value={"application/xml"})
@Consumes(value={"application/xml"})
@Path(value="book")
@TransactionAttribute(value=TransactionAttributeType.REQUIRED)
@ValidateRequest
@Stateless
public class BookResource {
    @PersistenceContext
    private EntityManager em;

    @GET
    public List<Book> getAllAuthors() {
        List books = this.em.createNamedQuery("books", Book.class).getResultList();
        for (Book b : books) {
            b.getAuthors().size();
        }
        return books;
    }

    @GET
    @Path(value="{id:[1-9][0-9]*}")
    public Book getBookById(@PathParam(value="id") Long bookId) {
        if (bookId == 2L) {
            throw new AccessControlException("No access");
        }
        Book b = (Book)this.em.createNamedQuery("booksById", Book.class).setParameter("id", (Object)bookId).getSingleResult();
        b.getAuthors().size();
        return b;
    }
}

