/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.jboss.seam.exception.control.HandlerMethod;
import org.jboss.seam.exception.control.TraversalPath;
import org.jboss.weld.extensions.reflection.HierarchyDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExceptionHandlerComparator
implements Comparator<HandlerMethod> {
    @Override
    public int compare(HandlerMethod lhs, HandlerMethod rhs) {
        if (lhs.equals(rhs)) {
            return 0;
        }
        if (lhs.getExceptionType().equals(rhs.getExceptionType())) {
            if (lhs.getTraversalPath() == rhs.getTraversalPath()) {
                int returnValue = this.comparePrecedence(lhs.getPrecedence(), rhs.getPrecedence());
                if (returnValue == 0 && !lhs.getQualifiers().isEmpty()) {
                    return -1;
                }
                return returnValue;
            }
            if (lhs.getTraversalPath() == TraversalPath.DESCENDING) {
                return -1;
            }
            return 1;
        }
        return this.compareHierarchies(lhs.getExceptionType(), rhs.getExceptionType());
    }

    private int compareHierarchies(Type lhsExceptionType, Type rhsExceptionType) {
        HierarchyDiscovery lhsHierarchy = new HierarchyDiscovery(lhsExceptionType);
        Set lhsTypeclosure = lhsHierarchy.getTypeClosure();
        if (lhsTypeclosure.contains(rhsExceptionType)) {
            int indoxOfLhsType = new ArrayList(lhsTypeclosure).indexOf(lhsExceptionType);
            int indoxOfRhsType = new ArrayList(lhsTypeclosure).indexOf(rhsExceptionType);
            return indoxOfLhsType - indoxOfRhsType;
        }
        return -1;
    }

    private int comparePrecedence(int lhs, int rhs) {
        return (lhs - rhs) * -1;
    }
}

