/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Set;
import org.jboss.seam.exception.control.HandlerMethod;
import org.jboss.seam.exception.control.TraversalMode;
import org.jboss.seam.solder.reflection.HierarchyDiscovery;

public final class ExceptionHandlerComparator
implements Comparator<HandlerMethod<?>> {
    @Override
    public int compare(HandlerMethod<?> lhs, HandlerMethod<?> rhs) {
        if (lhs.equals(rhs)) {
            return 0;
        }
        if (lhs.getExceptionType().equals(rhs.getExceptionType())) {
            int returnValue = this.comparePrecedence(lhs.getPrecedence(), rhs.getPrecedence(), lhs.getTraversalMode() == TraversalMode.DEPTH_FIRST);
            if (returnValue == 0 && !lhs.getQualifiers().isEmpty()) {
                return -1;
            }
            return returnValue;
        }
        return this.compareHierarchies(lhs.getExceptionType(), rhs.getExceptionType());
    }

    private int compareHierarchies(Type lhsExceptionType, Type rhsExceptionType) {
        int indexOfRhsType;
        int indexOfLhsType;
        HierarchyDiscovery lhsHierarchy = new HierarchyDiscovery(lhsExceptionType);
        Set lhsTypeclosure = lhsHierarchy.getTypeClosure();
        if (lhsTypeclosure.contains(rhsExceptionType) && (indexOfLhsType = new ArrayList(lhsTypeclosure).indexOf(lhsExceptionType)) > (indexOfRhsType = new ArrayList(lhsTypeclosure).indexOf(rhsExceptionType))) {
            return 1;
        }
        return -1;
    }

    private int comparePrecedence(int lhs, int rhs, boolean isAsc) {
        if (isAsc) {
            return lhs - rhs;
        }
        return (lhs - rhs) * -1;
    }
}

