/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control;

import org.jboss.seam.exception.control.ExceptionStack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaughtException<T extends Throwable> {
    private final ExceptionStack exceptionStack;
    private final T exception;
    private boolean unmute;
    private ExceptionHandlingFlow flow;
    private Throwable throwNewException;
    private final boolean descendingTraversal;
    private final boolean ascendingTraversal;
    private final boolean markedHandled;

    public CaughtException(ExceptionStack exceptionStack, boolean descendingTraversal, boolean handled) {
        if (exceptionStack == null) {
            throw new IllegalArgumentException("null is not valid for exceptionStack");
        }
        this.exception = exceptionStack.getCurrent();
        this.exceptionStack = exceptionStack;
        this.descendingTraversal = descendingTraversal;
        this.ascendingTraversal = !descendingTraversal;
        this.markedHandled = handled;
        this.flow = ExceptionHandlingFlow.MARK_HANDLED;
    }

    public T getException() {
        return this.exception;
    }

    public void abort() {
        this.flow = ExceptionHandlingFlow.ABORT;
    }

    public void rethrow() {
        this.flow = ExceptionHandlingFlow.RETHROW;
    }

    public void handled() {
        this.flow = ExceptionHandlingFlow.HANDLED;
    }

    public void markHandled() {
        this.flow = ExceptionHandlingFlow.MARK_HANDLED;
    }

    public void dropCause() {
        this.flow = ExceptionHandlingFlow.DROP_CAUSE;
    }

    public void unmute() {
        this.unmute = true;
    }

    public boolean isDescendingTraversal() {
        return this.descendingTraversal;
    }

    public boolean isAscendingTraversal() {
        return this.ascendingTraversal;
    }

    protected boolean isUnmute() {
        return this.unmute;
    }

    public ExceptionStack getExceptionStack() {
        return this.exceptionStack;
    }

    protected ExceptionHandlingFlow getFlow() {
        return this.flow;
    }

    public boolean isMarkedHandled() {
        return this.markedHandled;
    }

    public void rethrow(Throwable t) {
        this.throwNewException = t;
        this.flow = ExceptionHandlingFlow.THROW;
    }

    protected Throwable getThrowNewException() {
        return this.throwNewException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum ExceptionHandlingFlow {
        HANDLED,
        MARK_HANDLED,
        DROP_CAUSE,
        ABORT,
        RETHROW,
        THROW;

    }
}

