/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExceptionStack {
    private final boolean root;
    private final boolean last;
    private final int index;
    private final Throwable next;
    private final Collection<Throwable> remaining;
    private final Collection<Throwable> elements;
    private final Throwable current;

    public ExceptionStack(Collection<Throwable> causeChainElements, int currentElementIndex) {
        if (causeChainElements == null || causeChainElements.size() == 0) {
            throw new IllegalArgumentException("Null or empty collection of causeChainElements is not valid");
        }
        this.elements = Collections.unmodifiableCollection(causeChainElements);
        this.index = currentElementIndex;
        this.last = this.index == 0;
        this.root = this.index == causeChainElements.size() - 1;
        this.next = this.index - 1 >= 0 ? (Throwable)this.elements.toArray()[this.index - 1] : null;
        this.remaining = new ArrayList<Throwable>(this.elements).subList(0, currentElementIndex);
        this.current = (Throwable)this.elements.toArray()[this.index];
    }

    public Collection<Throwable> getCauseElements() {
        return Collections.unmodifiableCollection(this.elements);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isLast() {
        return this.last;
    }

    public Throwable getNext() {
        return this.next;
    }

    public Collection<Throwable> getRemaining() {
        return Collections.unmodifiableCollection(this.remaining);
    }

    public boolean isRoot() {
        return this.root;
    }

    public Throwable getCurrent() {
        return this.current;
    }
}

