/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.exception.control.CaughtException;
import org.jboss.seam.exception.control.HandlerMethod;
import org.jboss.seam.exception.control.Handles;
import org.jboss.seam.exception.control.OutboundParameterValueRedefiner;
import org.jboss.seam.exception.control.TraversalPath;
import org.jboss.seam.solder.bean.Beans;
import org.jboss.seam.solder.literal.AnyLiteral;
import org.jboss.seam.solder.reflection.annotated.InjectableMethod;
import org.jboss.seam.solder.reflection.annotated.ParameterValueRedefiner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerMethodImpl<T extends Throwable>
implements HandlerMethod<T> {
    private final Class<?> beanClass;
    private Bean<?> bean;
    private final Set<Annotation> qualifiers;
    private final Type exceptionType;
    private final AnnotatedMethod handler;
    private final TraversalPath traversalPath;
    private final int precedence;
    private final Method javaMethod;

    public HandlerMethodImpl(AnnotatedMethod method, BeanManager bm) {
        AnnotatedParameter handlesParam;
        HashSet<Annotation> tmpQualifiers = new HashSet<Annotation>();
        if (method == null || method.getParameters() == null || method.getParameters().size() == 0) {
            throw new IllegalArgumentException("Method must not be null and must have at least one parameter");
        }
        this.handler = method;
        this.javaMethod = method.getJavaMember();
        if (!this.javaMethod.isAccessible()) {
            this.javaMethod.setAccessible(true);
        }
        if (!(handlesParam = (AnnotatedParameter)method.getParameters().get(0)).isAnnotationPresent(Handles.class)) {
            throw new IllegalArgumentException("Method is not annotated with @Handles");
        }
        this.traversalPath = ((Handles)handlesParam.getAnnotation(Handles.class)).during();
        this.precedence = ((Handles)handlesParam.getAnnotation(Handles.class)).precedence();
        tmpQualifiers.addAll(Beans.getQualifiers((BeanManager)bm, (Iterable)handlesParam.getAnnotations()));
        if (tmpQualifiers.isEmpty()) {
            tmpQualifiers.add((Annotation)AnyLiteral.INSTANCE);
        }
        this.qualifiers = tmpQualifiers;
        this.beanClass = method.getJavaMember().getDeclaringClass();
        this.exceptionType = ((ParameterizedType)handlesParam.getBaseType()).getActualTypeArguments()[0];
    }

    @Override
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Override
    public synchronized Bean<?> getBean(BeanManager bm) {
        if (this.bean == null) {
            this.bean = bm.resolve(bm.getBeans(this.beanClass, new Annotation[0]));
        }
        return this.bean;
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return Collections.unmodifiableSet(this.qualifiers);
    }

    @Override
    public Type getExceptionType() {
        return this.exceptionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(CaughtException<T> event, BeanManager bm) {
        CreationalContext ctx = null;
        try {
            ctx = bm.createCreationalContext(null);
            Object handlerInstance = bm.getReference(this.getBean(bm), this.beanClass, ctx);
            InjectableMethod im = new InjectableMethod(this.handler, this.getBean(bm), bm);
            im.invoke(handlerInstance, ctx, (ParameterValueRedefiner)new OutboundParameterValueRedefiner(event, bm, this.getBean(bm)));
        }
        finally {
            if (ctx != null) {
                ctx.release();
            }
        }
    }

    @Override
    public TraversalPath getTraversalPath() {
        return this.traversalPath;
    }

    @Override
    public int getPrecedence() {
        return this.precedence;
    }

    @Override
    public Method getJavaMethod() {
        return this.javaMethod;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HandlerMethodImpl that = (HandlerMethodImpl)o;
        if (this.precedence != that.precedence) {
            return false;
        }
        if (!this.beanClass.equals(that.beanClass)) {
            return false;
        }
        if (!this.exceptionType.equals(that.exceptionType)) {
            return false;
        }
        if (!this.handler.equals(that.handler)) {
            return false;
        }
        if (!this.javaMethod.equals(that.javaMethod)) {
            return false;
        }
        if (!((Object)this.qualifiers).equals(that.qualifiers)) {
            return false;
        }
        return this.traversalPath == that.traversalPath;
    }

    public int hashCode() {
        int result = this.beanClass.hashCode();
        result = 5 * result + ((Object)this.qualifiers).hashCode();
        result = 5 * result + this.exceptionType.hashCode();
        result = 5 * result + this.handler.hashCode();
        result = 5 * result + this.traversalPath.hashCode();
        result = 5 * result + this.precedence;
        result = 5 * result + this.javaMethod.hashCode();
        return result;
    }

    public String toString() {
        return "Qualifiers: " + this.qualifiers + " " + this.handler.toString();
    }
}

