/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control.extension;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ProcessBean;
import org.jboss.seam.exception.control.ExceptionHandlerComparator;
import org.jboss.seam.exception.control.HandlerMethod;
import org.jboss.seam.exception.control.HandlerMethodImpl;
import org.jboss.seam.exception.control.Handles;
import org.jboss.seam.exception.control.HandlesExceptions;
import org.jboss.seam.solder.literal.AnyLiteral;
import org.jboss.seam.solder.reflection.HierarchyDiscovery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CatchExtension
implements Extension {
    private final Map<? super Type, Collection<HandlerMethod>> allHandlers = new HashMap<Type, Collection<HandlerMethod>>();

    public void findHandlers(@Observes ProcessBean pmb, BeanManager bm) {
        if (!(pmb.getAnnotated() instanceof AnnotatedType) || pmb.getBean() instanceof Interceptor || pmb.getBean() instanceof Decorator) {
            return;
        }
        AnnotatedType type = (AnnotatedType)pmb.getAnnotated();
        if (CatchExtension.isAnnotationPresent((Annotated)type, HandlesExceptions.class, bm)) {
            Set methods = type.getMethods();
            for (AnnotatedMethod method : methods) {
                AnnotatedParameter p;
                Class exceptionType;
                if (method.getParameters().size() <= 0 || !((AnnotatedParameter)method.getParameters().get(0)).isAnnotationPresent(Handles.class)) continue;
                if (method.getJavaMember().getExceptionTypes().length != 0) {
                    pmb.addDefinitionError((Throwable)new IllegalArgumentException(String.format("Handler method %s must not throw exceptions", method.getJavaMember())));
                }
                if (this.allHandlers.containsKey(exceptionType = (Class)((ParameterizedType)(p = (AnnotatedParameter)method.getParameters().get(0)).getBaseType()).getActualTypeArguments()[0])) {
                    this.allHandlers.get(exceptionType).add(new HandlerMethodImpl(method, bm));
                    continue;
                }
                this.allHandlers.put(exceptionType, new HashSet<HandlerMethodImpl>(Arrays.asList(new HandlerMethodImpl(method, bm))));
            }
        }
    }

    public Collection<HandlerMethod> getHandlersForExceptionType(Type exceptionClass, BeanManager bm, Set<Annotation> handlerQualifiers) {
        TreeSet<HandlerMethod> returningHandlers = new TreeSet<HandlerMethod>(new ExceptionHandlerComparator());
        HierarchyDiscovery h = new HierarchyDiscovery(exceptionClass);
        Set closure = h.getTypeClosure();
        for (Type hierarchyType : closure) {
            if (this.allHandlers.get(hierarchyType) == null) continue;
            for (HandlerMethod handler : this.allHandlers.get(hierarchyType)) {
                if (handler.getQualifiers().contains(AnyLiteral.INSTANCE)) {
                    returningHandlers.add(handler);
                    continue;
                }
                if (handlerQualifiers.isEmpty() || !this.containsAny(handler.getQualifiers(), handlerQualifiers)) continue;
                returningHandlers.add(handler);
            }
        }
        return Collections.unmodifiableCollection(returningHandlers);
    }

    private boolean containsAny(Collection<? extends Annotation> haystack, Collection<? extends Annotation> needles) {
        for (Annotation annotation : needles) {
            if (!haystack.contains(annotation)) continue;
            return true;
        }
        return false;
    }

    private static <A extends Annotation> boolean isAnnotationPresent(Annotated annotated, Class<A> annotationType, BeanManager beanManager) {
        if (annotated.isAnnotationPresent(annotationType)) {
            return true;
        }
        for (Annotation candidate : annotated.getAnnotations()) {
            if (!beanManager.isStereotype(candidate.annotationType())) continue;
            for (Annotation stereotyped : beanManager.getStereotypeDefinition(candidate.annotationType())) {
                if (!stereotyped.annotationType().equals(annotationType)) continue;
                return true;
            }
        }
        return false;
    }
}

