/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.exception.control;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class ExceptionStack
implements Serializable {
    private static final long serialVersionUID = 5988683320170873619L;
    private boolean root;
    private boolean last;
    private int index;
    private Throwable next;
    private Collection<Throwable> remaining;
    private Collection<Throwable> elements;
    private Throwable current;

    public ExceptionStack() {
    }

    public ExceptionStack(Throwable exception) {
        if (exception == null) {
            throw new IllegalArgumentException("exception must not be null");
        }
        Throwable e = exception;
        this.elements = new ArrayList<Throwable>();
        do {
            this.elements.add(e);
            if (!(e instanceof SQLException)) continue;
            SQLException sqlException = (SQLException)e;
            while (sqlException.getNextException() != null) {
                sqlException = sqlException.getNextException();
                this.elements.add(sqlException);
            }
        } while ((e = e.getCause()) != null);
        this.index = this.elements.size() - 1;
        this.init();
    }

    public ExceptionStack(Collection<Throwable> causeChainElements, int currentElementIndex) {
        if (causeChainElements == null || causeChainElements.size() == 0) {
            throw new IllegalArgumentException("Null or empty collection of causeChainElements is not valid");
        }
        if (currentElementIndex >= causeChainElements.size()) {
            throw new IllegalArgumentException("currentElementIndex must be less than or equals to causeChainElements.size()");
        }
        this.elements = Collections.unmodifiableCollection(causeChainElements);
        this.index = currentElementIndex;
        this.init();
    }

    private void init() {
        this.root = this.index == this.elements.size() - 1;
        Throwable throwable = this.next = this.index - 1 >= 0 ? (Throwable)this.elements.toArray()[this.index - 1] : null;
        if (this.index >= 0) {
            this.remaining = new ArrayList<Throwable>(this.elements).subList(0, this.index);
            this.current = (Throwable)this.elements.toArray()[this.index];
        } else {
            this.remaining = Collections.emptyList();
            this.current = null;
        }
        this.last = this.remaining.isEmpty();
    }

    public Collection<Throwable> getCauseElements() {
        return Collections.unmodifiableCollection(this.elements);
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isLast() {
        return this.last;
    }

    public Throwable getNext() {
        return this.next;
    }

    public Collection<Throwable> getRemaining() {
        return Collections.unmodifiableCollection(this.remaining);
    }

    public boolean isRoot() {
        return this.root;
    }

    public Throwable getCurrent() {
        return this.current;
    }

    public void setCauseElements(Collection<Throwable> elements) {
        this.elements = Collections.unmodifiableCollection(elements);
        this.init();
    }

    public void setIndex(int index) {
        if (index >= this.elements.size()) {
            throw new IllegalArgumentException("Index greater than elements.size()");
        }
        this.index = index;
        this.init();
    }

    protected void advanceToNextCause() {
        this.setIndex(this.index - 1);
    }
}

