/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.config.xml.bootstrap;

import java.lang.annotation.Annotation;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.inject.Named;
import org.jboss.logging.Logger;
import org.jboss.seam.config.xml.bootstrap.ProcessAnnotatedTypeImpl;
import org.jboss.seam.config.xml.bootstrap.XmlDocument;
import org.jboss.seam.config.xml.bootstrap.XmlDocumentProvider;
import org.jboss.seam.config.xml.core.BeanResult;
import org.jboss.seam.config.xml.core.XmlConfiguredBean;
import org.jboss.seam.config.xml.core.XmlId;
import org.jboss.seam.config.xml.core.XmlResult;
import org.jboss.seam.config.xml.fieldset.FieldValueObject;
import org.jboss.seam.config.xml.fieldset.InjectionTargetWrapper;
import org.jboss.seam.config.xml.model.ModelBuilder;
import org.jboss.seam.config.xml.parser.ParserMain;
import org.jboss.seam.config.xml.parser.SaxNode;
import org.jboss.seam.config.xml.util.FileDataReader;
import org.jboss.seam.solder.literal.DefaultLiteral;
import org.jboss.seam.solder.reflection.AnnotationInstanceProvider;

public class XmlConfigExtension
implements Extension {
    private AnnotationInstanceProvider annotationInstanceProvider = new AnnotationInstanceProvider();
    static final String PROVIDERS_FILE = "META-INF/services/" + XmlDocumentProvider.class.getName();
    private List<XmlResult> results = new ArrayList<XmlResult>();
    private Set<Class<?>> veto = new HashSet();
    private int count = 0;
    private static final Logger log = Logger.getLogger(XmlConfigExtension.class);
    private Map<Integer, List<FieldValueObject>> fieldValues = new HashMap<Integer, List<FieldValueObject>>();
    private List<Exception> errors = new ArrayList<Exception>();

    public void beforeBeanDiscovery(@Observes BeforeBeanDiscovery event, BeanManager beanManager) {
        log.info((Object)"Seam Config XML provider starting...");
        List<Class<? extends XmlDocumentProvider>> providers = this.getDocumentProviders();
        for (Class<? extends XmlDocumentProvider> cl : providers) {
            try {
                XmlDocument xmlDocument;
                XmlDocumentProvider provider = cl.newInstance();
                provider.open();
                while ((xmlDocument = provider.getNextDocument()) != null) {
                    log.info((Object)("Reading XML file: " + xmlDocument.getFileUrl()));
                    ParserMain parser = new ParserMain();
                    ModelBuilder builder = new ModelBuilder(xmlDocument.getFileUrl());
                    SaxNode parentNode = parser.parse(xmlDocument.getInputSource(), xmlDocument.getFileUrl(), this.errors);
                    this.results.add(builder.build(parentNode, beanManager));
                }
            }
            catch (Exception e) {
                this.errors.add(e);
            }
        }
        Collections.sort(this.results);
        for (XmlResult r : this.results) {
            for (Class<? extends Annotation> clazz : r.getQualifiers()) {
                log.info((Object)("Adding XML Defined Qualifier: " + clazz.getName()));
                event.addQualifier(clazz);
            }
            for (Class<? extends Annotation> clazz : r.getInterceptorBindings()) {
                log.info((Object)("Adding XML Defined Interceptor Binding: " + clazz.getName()));
                event.addInterceptorBinding(clazz, new Annotation[0]);
            }
            for (Map.Entry entry : r.getStereotypes().entrySet()) {
                log.info((Object)("Adding XML Defined Stereotype: " + ((Class)entry.getKey()).getName()));
                event.addStereotype((Class)entry.getKey(), (Annotation[])entry.getValue());
            }
        }
        for (XmlResult r : this.results) {
            if (!r.getProblems().isEmpty()) {
                for (String string : r.getProblems()) {
                    this.errors.add(new Exception(string));
                }
            }
            for (BeanResult beanResult : r.getFlattenedBeans()) {
                int val;
                if (beanResult.getFieldValues().isEmpty()) continue;
                ++this.count;
                this.fieldValues.put(val, beanResult.getFieldValues());
                HashMap<String, Integer> am = new HashMap<String, Integer>();
                am.put("value", val);
                Annotation a = this.annotationInstanceProvider.get(XmlId.class, am);
                beanResult.addToClass(a);
            }
            for (BeanResult beanResult : r.getFlattenedBeans()) {
                AnnotatedType<?> tp = beanResult.getAnnotatedType();
                log.info((Object)("Adding XML Defined Bean: " + tp.getJavaClass().getName()));
                ProcessAnnotatedTypeImpl pat = new ProcessAnnotatedTypeImpl(tp);
                beanManager.fireEvent((Object)pat, new Annotation[]{DefaultLiteral.INSTANCE});
                event.addAnnotatedType(pat.getAnnotatedType());
            }
            this.veto.addAll(r.getVeto());
        }
    }

    public <T> void processAnotated(@Observes ProcessAnnotatedType<T> event, BeanManager manager) {
        if (event.getAnnotatedType().isAnnotationPresent(XmlConfiguredBean.class)) {
            return;
        }
        if (this.veto.contains(event.getAnnotatedType().getJavaClass())) {
            log.info((Object)("Preventing installation of default bean: " + event.getAnnotatedType().getJavaClass().getName()));
            event.veto();
            return;
        }
    }

    public <T> void processInjectionTarget(@Observes ProcessInjectionTarget<T> event, BeanManager manager) {
        AnnotatedType at = event.getAnnotatedType();
        XmlId xid = (XmlId)at.getAnnotation(XmlId.class);
        if (xid != null) {
            log.info((Object)("Wrapping InjectionTarget to set field values: " + event.getAnnotatedType().getJavaClass().getName()));
            List<FieldValueObject> fvs = this.fieldValues.get(xid.value());
            event.setInjectionTarget(new InjectionTargetWrapper(event.getInjectionTarget(), fvs, manager));
        }
    }

    public void processAfterBeanDeployment(@Observes AfterBeanDiscovery event) {
        for (Exception t : this.errors) {
            event.addDefinitionError((Throwable)t);
        }
    }

    public List<Class<? extends XmlDocumentProvider>> getDocumentProviders() {
        ArrayList<Class<? extends XmlDocumentProvider>> ret = new ArrayList<Class<? extends XmlDocumentProvider>>();
        try {
            Enumeration<URL> urls = this.getClass().getClassLoader().getResources(PROVIDERS_FILE);
            while (urls.hasMoreElements()) {
                String[] providers;
                URL u = urls.nextElement();
                String data = FileDataReader.readUrl(u);
                for (String provider : providers = data.split("\\s")) {
                    log.info((Object)("Loading XmlDocumentProvider: " + provider));
                    Class<?> res = null;
                    try {
                        res = this.getClass().getClassLoader().loadClass(provider);
                    }
                    catch (ClassNotFoundException e) {
                        res = Thread.currentThread().getContextClassLoader().loadClass(provider);
                    }
                    if (res == null) {
                        throw new RuntimeException("Could not load XML configuration provider " + provider + " configured in file " + u.toString());
                    }
                    ret.add(res);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    public boolean isQualifierPresent(Annotated f, BeanManager beanManager) {
        for (Annotation a : f.getAnnotations()) {
            if (a.annotationType().equals(Named.class) || !beanManager.isQualifier(a.annotationType())) continue;
            return true;
        }
        return false;
    }
}

