/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.config.xml.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.seam.config.xml.bootstrap.XmlDocument;
import org.jboss.seam.config.xml.bootstrap.XmlDocumentProvider;
import org.jboss.seam.solder.resourceLoader.ResourceLoaderManager;
import org.xml.sax.InputSource;

public class ResourceLoaderXmlDocumentProvider
implements XmlDocumentProvider {
    private final ResourceLoaderManager manager = new ResourceLoaderManager();
    static final String[] DEFAULT_RESOURCES = new String[]{"META-INF/seam-beans.xml", "META-INF/beans.xml", "WEB-INF/beans.xml", "WEB-INF/seam-beans.xml"};
    final String[] resources;
    InputStream stream;
    List<URL> docs;
    ListIterator<URL> iterator;
    DocumentBuilderFactory factory;
    DocumentBuilder builder;

    public ResourceLoaderXmlDocumentProvider() {
        this(DEFAULT_RESOURCES);
    }

    public ResourceLoaderXmlDocumentProvider(String[] resources) {
        this.resources = resources;
    }

    @Override
    public void open() {
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
        this.factory.setIgnoringComments(true);
        this.factory.setIgnoringElementContentWhitespace(true);
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e1) {
            throw new RuntimeException(e1);
        }
        this.docs = new ArrayList<URL>();
        for (String i : this.resources) {
            Collection e = this.manager.getResources(i);
            this.docs.addAll(e);
        }
        this.iterator = this.docs.listIterator();
    }

    @Override
    public void close() {
        if (this.stream != null) {
            try {
                this.stream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public XmlDocument getNextDocument() {
        if (this.stream != null) {
            try {
                this.stream.close();
                this.stream = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            URL url;
            while (true) {
                if (!this.iterator.hasNext()) {
                    return null;
                }
                url = this.iterator.next();
                InputStream test = null;
                try {
                    test = url.openStream();
                    if (test.available() != 0) break;
                    continue;
                }
                finally {
                    if (test == null) continue;
                    test.close();
                    continue;
                }
                break;
            }
            return new XmlDocument(){

                @Override
                public InputSource getInputSource() {
                    try {
                        ResourceLoaderXmlDocumentProvider.this.stream = url.openStream();
                        return new InputSource(ResourceLoaderXmlDocumentProvider.this.stream);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public String getFileUrl() {
                    return url.toString();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

