/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.config.xml.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Scope;
import org.jboss.seam.config.xml.core.BeanResultType;
import org.jboss.seam.config.xml.core.XmlConfiguredBeanLiteral;
import org.jboss.seam.config.xml.fieldset.FieldValueObject;
import org.jboss.seam.solder.core.Veto;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;

public class BeanResult<X> {
    private final AnnotatedTypeBuilder<X> builder;
    private final Class<X> type;
    private final BeanResultType beanType;
    private final List<FieldValueObject> fieldValues;
    private final List<BeanResult<?>> inlineBeans;
    private final BeanManager beanManager;

    public BeanResult(Class<X> type, boolean readAnnotations, BeanResultType beanType, List<FieldValueObject> fieldValues, List<BeanResult<?>> inlineBeans, BeanManager beanManager) {
        this.beanManager = beanManager;
        this.type = type;
        this.builder = new AnnotatedTypeBuilder().setJavaClass(type);
        this.builder.addToClass((Annotation)XmlConfiguredBeanLiteral.INSTANCE);
        if (readAnnotations) {
            this.builder.readFromType(type);
            this.builder.removeFromClass(Veto.class);
        }
        this.beanType = beanType;
        this.fieldValues = new ArrayList<FieldValueObject>(fieldValues);
        this.inlineBeans = new ArrayList(inlineBeans);
    }

    public List<BeanResult<?>> getInlineBeans() {
        return this.inlineBeans;
    }

    public Class<X> getType() {
        return this.type;
    }

    public BeanResultType getBeanType() {
        return this.beanType;
    }

    public List<FieldValueObject> getFieldValues() {
        return Collections.unmodifiableList(this.fieldValues);
    }

    public void addToClass(Annotation annotation) {
        if (annotation.annotationType().isAnnotationPresent(Scope.class) || annotation.annotationType().isAnnotationPresent(NormalScope.class)) {
            for (Annotation typeAnnotation : this.type.getAnnotations()) {
                if (!typeAnnotation.annotationType().isAnnotationPresent(Scope.class) && !typeAnnotation.annotationType().isAnnotationPresent(NormalScope.class)) continue;
                this.builder.removeFromClass(typeAnnotation.annotationType());
            }
        }
        this.builder.addToClass(annotation);
    }

    public void addToField(Field field, Annotation annotation) {
        if (annotation.annotationType().isAnnotationPresent(Scope.class) || annotation.annotationType().isAnnotationPresent(NormalScope.class)) {
            for (Annotation typeAnnotation : field.getAnnotations()) {
                if (!typeAnnotation.annotationType().isAnnotationPresent(Scope.class) && !typeAnnotation.annotationType().isAnnotationPresent(NormalScope.class)) continue;
                this.builder.removeFromField(field, typeAnnotation.annotationType());
            }
        }
        this.builder.addToField(field, annotation);
    }

    public void addToMethod(Method method, Annotation annotation) {
        if (annotation.annotationType().isAnnotationPresent(Scope.class) || annotation.annotationType().isAnnotationPresent(NormalScope.class)) {
            for (Annotation typeAnnotation : method.getAnnotations()) {
                if (!typeAnnotation.annotationType().isAnnotationPresent(Scope.class) && !typeAnnotation.annotationType().isAnnotationPresent(NormalScope.class)) continue;
                this.builder.removeFromMethod(method, typeAnnotation.annotationType());
            }
        }
        this.builder.addToMethod(method, annotation);
    }

    public void addToMethodParameter(Method method, int param, Annotation annotation) {
        this.builder.addToMethodParameter(method, param, annotation);
    }

    public void addToConstructor(Constructor<?> constructor, Annotation annotation) {
        this.builder.addToConstructor(constructor, annotation);
    }

    public void addToConstructorParameter(Constructor<?> constructor, int param, Annotation annotation) {
        this.builder.addToConstructorParameter(constructor, param, annotation);
    }

    public void overrideFieldType(Field field, Class<?> javaClass) {
        this.builder.overrideFieldType(field, javaClass);
    }

    public AnnotatedType<?> getAnnotatedType() {
        return this.builder.create();
    }
}

