/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.config.xml.model;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.BeanManager;
import org.jboss.seam.config.xml.core.BeanResult;
import org.jboss.seam.config.xml.core.BeanResultType;
import org.jboss.seam.config.xml.core.VirtualProducerField;
import org.jboss.seam.config.xml.fieldset.FieldValueObject;
import org.jboss.seam.config.xml.model.AbstractXmlItem;
import org.jboss.seam.config.xml.model.AnnotationUtils;
import org.jboss.seam.config.xml.model.AnnotationXmlItem;
import org.jboss.seam.config.xml.model.MethodXmlItem;
import org.jboss.seam.config.xml.model.ModifiesXmlItem;
import org.jboss.seam.config.xml.model.ParameterXmlItem;
import org.jboss.seam.config.xml.model.ParametersXmlItem;
import org.jboss.seam.config.xml.model.PropertyXmlItem;
import org.jboss.seam.config.xml.model.ReplacesXmlItem;
import org.jboss.seam.config.xml.model.XmlItem;
import org.jboss.seam.config.xml.model.XmlItemType;
import org.jboss.seam.config.xml.util.TypeOccuranceInformation;
import org.jboss.seam.config.xml.util.XmlConfigurationException;
import org.jboss.seam.solder.literal.InjectLiteral;
import org.jboss.seam.solder.properties.Properties;
import org.jboss.seam.solder.properties.Property;
import org.jboss.seam.solder.properties.query.NamedPropertyCriteria;
import org.jboss.seam.solder.properties.query.PropertyCriteria;
import org.jboss.seam.solder.properties.query.PropertyQueries;
import org.jboss.seam.solder.properties.query.PropertyQuery;
import org.jboss.seam.solder.reflection.Reflections;

public class ClassXmlItem
extends AbstractXmlItem {
    private HashSet<TypeOccuranceInformation> allowed = new HashSet();

    public ClassXmlItem(XmlItem parent, Class<?> c, Map<String, String> attributes, String document, int lineno) {
        super(XmlItemType.CLASS, parent, c, null, attributes, document, lineno);
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.ANNOTATION, null, null));
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.FIELD, null, null));
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.METHOD, null, null));
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.PARAMETERS, null, null));
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.REPLACE, null, null));
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.MODIFIES, null, null));
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.VALUE, null, null));
        this.allowed.add(TypeOccuranceInformation.of(XmlItemType.ENTRY, null, null));
    }

    @Override
    public Set<TypeOccuranceInformation> getAllowedItem() {
        return this.allowed;
    }

    public Set<PropertyXmlItem> getShorthandFieldValues() {
        HashSet<PropertyXmlItem> values = new HashSet<PropertyXmlItem>();
        for (Map.Entry e : this.attributes.entrySet()) {
            PropertyQuery query = PropertyQueries.createQuery(this.getJavaClass());
            query.addCriteria((PropertyCriteria)new NamedPropertyCriteria(new String[]{(String)e.getKey()}));
            Property property = query.getFirstWritableResult();
            if (property != null) {
                property.setAccessible();
                values.add(new PropertyXmlItem(this, (Property<Object>)property, (String)e.getValue(), null, this.document, this.lineno));
                continue;
            }
            throw new XmlConfigurationException("Could not resolve field: " + (String)e.getKey(), this.document, this.lineno);
        }
        return values;
    }

    public BeanResult<?> createBeanResult(BeanManager manager) {
        boolean extend;
        boolean override = !this.getChildrenOfType(ReplacesXmlItem.class).isEmpty();
        boolean bl = extend = !this.getChildrenOfType(ModifiesXmlItem.class).isEmpty();
        if (override && extend) {
            throw new XmlConfigurationException("A bean may not both <override> and <extend> an existing bean", this.getDocument(), this.getLineno());
        }
        BeanResultType beanType = override ? BeanResultType.REPLACES : (extend ? BeanResultType.MODIFIES : BeanResultType.ADD);
        ArrayList inlineBeans = new ArrayList();
        HashSet<String> configuredFields = new HashSet<String>();
        ArrayList<FieldValueObject> fields = new ArrayList<FieldValueObject>();
        for (PropertyXmlItem xi : this.getChildrenOfType(PropertyXmlItem.class)) {
            inlineBeans.addAll(xi.getInlineBeans());
            FieldValueObject f = xi.getFieldValue();
            if (f == null) continue;
            fields.add(f);
            configuredFields.add(xi.getFieldName());
        }
        for (PropertyXmlItem f : this.getShorthandFieldValues()) {
            if (configuredFields.contains(f.getFieldName())) {
                throw new XmlConfigurationException("Field configured in two places: " + this.getJavaClass().getName() + "." + f.getFieldName(), this.getDocument(), this.getLineno());
            }
            fields.add(f.getFieldValue());
        }
        BeanResult result = new BeanResult(this.getJavaClass(), extend, beanType, fields, inlineBeans, manager);
        ArrayList<ParameterXmlItem> constList = new ArrayList<ParameterXmlItem>();
        for (AnnotationXmlItem item : this.getChildrenOfType(AnnotationXmlItem.class)) {
            Annotation annotation = AnnotationUtils.createAnnotation(item);
            result.addToClass(annotation);
        }
        List<ParametersXmlItem> constructorParameters = this.getChildrenOfType(ParametersXmlItem.class);
        if (constructorParameters.size() > 1) {
            throw new XmlConfigurationException("A method may only have a single <parameters> element", this.getDocument(), this.getLineno());
        }
        if (!constructorParameters.isEmpty()) {
            for (ParameterXmlItem parameterXmlItem : constructorParameters.get(0).getChildrenOfType(ParameterXmlItem.class)) {
                constList.add(parameterXmlItem);
            }
        }
        for (PropertyXmlItem propertyXmlItem : this.getChildrenOfType(PropertyXmlItem.class)) {
            if (propertyXmlItem.getField() != null) {
                for (AnnotationXmlItem annotationXmlItem : propertyXmlItem.getChildrenOfType(AnnotationXmlItem.class)) {
                    Annotation a = AnnotationUtils.createAnnotation(annotationXmlItem);
                    result.addToField(propertyXmlItem.getField(), a);
                }
                continue;
            }
            if (propertyXmlItem.getChildrenOfType(AnnotationXmlItem.class).isEmpty()) continue;
            throw new XmlConfigurationException("Property's that do not have an underlying field may not have annotations added to them", propertyXmlItem.getDocument(), propertyXmlItem.getLineno());
        }
        for (MethodXmlItem methodXmlItem : this.getChildrenOfType(MethodXmlItem.class)) {
            int paramCount = 0;
            for (AnnotationXmlItem fi : methodXmlItem.getChildrenOfType(AnnotationXmlItem.class)) {
                Annotation a = AnnotationUtils.createAnnotation(fi);
                result.addToMethod(methodXmlItem.getMethod(), a);
            }
            List<ParametersXmlItem> list = methodXmlItem.getChildrenOfType(ParametersXmlItem.class);
            if (list.size() > 1) {
                throw new XmlConfigurationException("A method may only have a single <parameters> element", methodXmlItem.getDocument(), methodXmlItem.getLineno());
            }
            if (list.isEmpty()) continue;
            for (ParameterXmlItem fi : list.get(0).getChildrenOfType(ParameterXmlItem.class)) {
                int param = paramCount++;
                for (AnnotationXmlItem pan : fi.getChildrenOfType(AnnotationXmlItem.class)) {
                    Annotation a = AnnotationUtils.createAnnotation(pan);
                    result.addToMethodParameter(methodXmlItem.getMethod(), param, a);
                }
            }
        }
        if (!constList.isEmpty()) {
            int paramCount = 0;
            Constructor<?> constructor = this.resolveConstructor(constList);
            result.addToConstructor(constructor, (Annotation)InjectLiteral.INSTANCE);
            for (ParameterXmlItem parameterXmlItem : constList) {
                int param = paramCount++;
                for (AnnotationXmlItem pan : parameterXmlItem.getChildrenOfType(AnnotationXmlItem.class)) {
                    Annotation a = AnnotationUtils.createAnnotation(pan);
                    result.addToConstructorParameter(constructor, param, a);
                }
            }
        }
        return result;
    }

    public BeanResult<?> createVirtualFieldBeanResult(BeanManager manager) {
        boolean extend;
        boolean override = !this.getChildrenOfType(ReplacesXmlItem.class).isEmpty();
        boolean bl = extend = !this.getChildrenOfType(ModifiesXmlItem.class).isEmpty();
        if (override || extend) {
            throw new XmlConfigurationException("A virtual producer field may not containe <override> or <extend> tags", this.getDocument(), this.getLineno());
        }
        Field member = org.jboss.seam.config.xml.util.Reflections.getField(VirtualProducerField.class, "field");
        member.setAccessible(true);
        ClassXmlItem vclass = new ClassXmlItem(null, VirtualProducerField.class, Collections.<String, String>emptyMap(), this.document, this.lineno);
        PropertyXmlItem field = new PropertyXmlItem(vclass, (Property<Object>)Properties.createProperty((Field)member), null, this.getJavaClass(), this.document, this.lineno);
        vclass.addChild(field);
        for (XmlItem i : this.getChildren()) {
            field.addChild(i);
        }
        field.resolveChildren(manager);
        BeanResult<?> result = vclass.createBeanResult(manager);
        result.overrideFieldType(member, this.getJavaClass());
        return result;
    }

    private Constructor<?> resolveConstructor(List<ParameterXmlItem> constList) {
        Class[] params = new Class[constList.size()];
        for (int i = 0; i < constList.size(); ++i) {
            params[i] = constList.get(i).getJavaClass();
        }
        Constructor ret = Reflections.findDeclaredConstructor(this.getJavaClass(), (Class[])params);
        if (ret == null) {
            throw new XmlConfigurationException("Could not resolve constructor for " + this.getJavaClass() + " with arguments " + params, this.getDocument(), this.getLineno());
        }
        return ret;
    }
}

