/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cron.asynchronous.threads;

import java.util.UUID;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.seam.cron.asynchronous.threads.AsyncMethodInvocationJob;
import org.jboss.seam.cron.impl.asynchronous.exception.AsynchronousMethodExecutionException;
import org.jboss.seam.cron.impl.scheduling.exception.CronProviderDestructionException;
import org.jboss.seam.cron.impl.scheduling.exception.CronProviderInitialisationException;
import org.jboss.seam.cron.spi.CronProviderLifecycle;
import org.jboss.seam.cron.spi.asynchronous.CronAsynchronousProvider;
import org.jboss.seam.cron.spi.asynchronous.Invoker;
import org.jboss.seam.cron.spi.asynchronous.support.FutureInvokerSupport;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.TriggerUtils;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;

public class QuartzAsynchronousProvider
implements CronProviderLifecycle,
CronAsynchronousProvider {
    public static final String ASYNC_JOB_GROUP = "async_job_group";
    public static final String INV_CONTEXT_EXECUTOR = "inv_context_executor";
    public static final String DELAYED_RESULT_SUPPORT = "future";
    private static final String SCHEDULER_NAME_PREFIX = "SeamCronScheduler";
    private String schedulerName;
    private Scheduler scheduler;
    private UUID instanceId;
    private static final Logger log = Logger.getLogger(QuartzAsynchronousProvider.class);
    @Inject
    BeanManager beanManager;

    public void initProvider() throws CronProviderInitialisationException {
        try {
            this.instanceId = UUID.randomUUID();
            RAMJobStore jobStore = new RAMJobStore();
            SimpleThreadPool threadPool = new SimpleThreadPool(4, 5);
            threadPool.initialize();
            DirectSchedulerFactory schedulerFactory = DirectSchedulerFactory.getInstance();
            this.schedulerName = "SeamCronScheduler_" + this.instanceId.toString();
            schedulerFactory.createScheduler(this.schedulerName, this.instanceId.toString(), (ThreadPool)threadPool, (JobStore)jobStore);
            this.scheduler = schedulerFactory.getScheduler(this.schedulerName);
            this.scheduler.start();
        }
        catch (SchedulerException ex) {
            throw new CronProviderInitialisationException("Error initialising Quartz for asynchronous method invocation");
        }
    }

    public void destroyProvider() throws CronProviderDestructionException {
        try {
            this.scheduler.shutdown();
        }
        catch (SchedulerException ex) {
            log.warn((Object)"Error shutting down scheduler", (Throwable)ex);
        }
    }

    public void executeWithoutReturn(Invoker inkover) {
        this.executeMethodAsScheduledJob(inkover);
    }

    public Future executeAndReturnFuture(Invoker invoker) {
        FutureTask asyncResult = new FutureTask(this.executeMethodAsScheduledJob(invoker));
        new Thread(asyncResult).start();
        return asyncResult;
    }

    private FutureInvokerSupport executeMethodAsScheduledJob(Invoker invoker) throws AsynchronousMethodExecutionException {
        FutureInvokerSupport drs = new FutureInvokerSupport(invoker);
        try {
            String name = UUID.randomUUID().toString();
            JobDetail jobDetail = new JobDetail(name, ASYNC_JOB_GROUP, AsyncMethodInvocationJob.class);
            jobDetail.getJobDataMap().put((Object)DELAYED_RESULT_SUPPORT, (Object)drs);
            this.scheduler.scheduleJob(jobDetail, TriggerUtils.makeImmediateTrigger((String)name, (int)0, (long)1L));
        }
        catch (SchedulerException ex) {
            throw new AsynchronousMethodExecutionException("Error invoking method asynchronously", (Throwable)ex);
        }
        return drs;
    }
}

