/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cron.test.asynchronous.beans;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.jboss.logging.Logger;
import org.jboss.seam.cron.api.asynchronous.AsyncResult;
import org.jboss.seam.cron.api.asynchronous.Asynchronous;
import org.jboss.seam.cron.test.asynchronous.beans.HaystackCount;
import org.jboss.seam.cron.test.asynchronous.beans.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class SomeAsynchMethods {
    public static final AtomicInteger count = new AtomicInteger(0);
    public static final int NUM_LOOPS = 2;
    public static final int SLEEP_PER_LOOP = 1000;
    private CountDownLatch statusLatch;
    private CountDownLatch heystackLatch;
    private Status statusEvent;
    private Integer haystackCount;
    private static final Logger log = Logger.getLogger(SomeAsynchMethods.class);

    public void reset() {
        this.statusEvent = null;
        this.haystackCount = null;
        this.statusLatch = new CountDownLatch(1);
        this.heystackLatch = new CountDownLatch(1);
    }

    @Asynchronous
    public void increment() {
        for (int i = 0; i < 2; ++i) {
            int c = count.incrementAndGet();
            System.out.println("Count: " + c);
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                log.error((Object)"Interrupted while sleeping", (Throwable)ex);
            }
        }
    }

    @Asynchronous
    public Status returnStatusObject(String statusToSet) {
        return new Status(statusToSet);
    }

    public void reportStatusForBoth(@Observes Status status) {
        this.statusEvent = status;
        this.statusLatch.countDown();
        System.out.println("The future is " + status.getDescription());
    }

    @Asynchronous
    public Future<Status> returnStatusInFuture(String statusToSet) {
        return new AsyncResult((Object)new Status(statusToSet));
    }

    @Asynchronous
    @HaystackCount
    public Integer countNeedlesInTheHaystack(int numToReturn) {
        return numToReturn;
    }

    @Asynchronous
    public Future<String> throwAnException() {
        String result = null;
        result.toString();
        return new AsyncResult((Object)"You won't get this far");
    }

    public void reportHaystackCount(@Observes @HaystackCount Integer count) {
        System.out.println("Needles in haystack: " + count);
        this.haystackCount = count;
        this.heystackLatch.countDown();
    }

    public CountDownLatch getStatusLatch() {
        return this.statusLatch;
    }

    public Status getStatusEvent() {
        return this.statusEvent;
    }

    public Integer getHaystackCount() {
        return this.haystackCount;
    }

    public CountDownLatch getHeystackLatch() {
        return this.heystackLatch;
    }
}

