/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cron.test.asynchronous.tck;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.logging.Logger;
import org.jboss.seam.cron.test.asynchronous.SeamCronAsynchronousTestBase;
import org.jboss.seam.cron.test.asynchronous.beans.SomeAsynchMethods;
import org.jboss.seam.cron.test.asynchronous.beans.Status;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SeamCronAsynchronousTCKTest {
    private static final int NUM_EXECUTIONS = 3;
    private static final Logger log = Logger.getLogger(SeamCronAsynchronousTCKTest.class);
    @Inject
    SomeAsynchMethods asynchBean;

    public static JavaArchive createAsynchronousTckTestArchive() {
        return (JavaArchive)SeamCronAsynchronousTestBase.createAsynchronousTestArchive().addPackage(SeamCronAsynchronousTCKTest.class.getPackage());
    }

    @Test
    public void testTypeLevelAsyncMethods() {
        log.info((Object)"Testing asynchronous methods on annotated bean are called asynchronously");
        for (int i = 0; i < 3; ++i) {
            this.asynchBean.increment();
        }
        Assert.assertTrue((SomeAsynchMethods.count.get() >= 0 ? 1 : 0) != 0);
        Assert.assertTrue((SomeAsynchMethods.count.get() < 6 ? 1 : 0) != 0);
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException ie) {
            log.error((Object)"Interrupted while sleeping", (Throwable)ie);
        }
        Assert.assertTrue((SomeAsynchMethods.count.get() == 6 ? 1 : 0) != 0);
    }

    @Test
    public void testPostExecutionNoQualifiers() throws InterruptedException {
        log.info((Object)"Testing asynchronous methods fire observable post-execution event");
        Assert.assertNotNull((Object)this.asynchBean);
        this.asynchBean.reset();
        Assert.assertNull((Object)this.asynchBean.getStatusEvent());
        Assert.assertNull((Object)this.asynchBean.getHaystackCount());
        String statusToSet = "orange";
        this.asynchBean.returnStatusObject(statusToSet);
        this.asynchBean.getStatusLatch().await(4L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)this.asynchBean.getStatusEvent());
        Assert.assertNull((Object)this.asynchBean.getHaystackCount());
        Assert.assertEquals((Object)statusToSet, (Object)this.asynchBean.getStatusEvent().getDescription());
    }

    @Test
    public void testPostExecutionHaystackQualifiers() throws InterruptedException {
        log.info((Object)"Testing asynchronous methods fire observable post-execution event");
        Assert.assertNotNull((Object)this.asynchBean);
        this.asynchBean.reset();
        Assert.assertNull((Object)this.asynchBean.getStatusEvent());
        Assert.assertNull((Object)this.asynchBean.getHaystackCount());
        Integer numNeedles = 11;
        this.asynchBean.countNeedlesInTheHaystack(numNeedles);
        this.asynchBean.getHeystackLatch().await(4L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)this.asynchBean.getHaystackCount());
        Assert.assertNull((Object)this.asynchBean.getStatusEvent());
        Assert.assertEquals((Object)numNeedles, (Object)this.asynchBean.getHaystackCount());
    }

    @Test
    public void testAsynchReturningFuture() throws InterruptedException, InterruptedException, ExecutionException, TimeoutException {
        log.info((Object)"Testing asynchronous methods return a future as expected");
        Assert.assertNotNull((Object)this.asynchBean);
        this.asynchBean.reset();
        Assert.assertNull((Object)this.asynchBean.getStatusEvent());
        Assert.assertNull((Object)this.asynchBean.getHaystackCount());
        String statusToSet = "blue";
        Future<Status> result = this.asynchBean.returnStatusInFuture(statusToSet);
        Assert.assertNotNull(result);
        Status resultStatus = result.get(4L, TimeUnit.SECONDS);
        Assert.assertNotNull((Object)resultStatus);
        Assert.assertNotNull((Object)resultStatus.getDescription());
        Assert.assertEquals((Object)statusToSet, (Object)resultStatus.getDescription());
        Assert.assertNull((Object)this.asynchBean.getHaystackCount());
    }

    @Test
    public void testErrorThrownReturnsAsPerEJBSpec() {
        log.info((Object)"Testing that an error thrown during an @Asynchronous invocation which returns a Future will be delivered to the caller as per the EJB spec");
        Assert.assertNotNull((Object)this.asynchBean);
        this.asynchBean.reset();
        Future<String> result = this.asynchBean.throwAnException();
        try {
            result.get(2L, TimeUnit.SECONDS);
            Assert.fail((String)"If you got here, the asynch method didn't throw an exception properly");
        }
        catch (ExecutionException ee) {
            log.info((Object)"The correct kind of exception was found");
            Assert.assertEquals(NullPointerException.class, ee.getCause().getClass());
        }
        catch (TimeoutException toe) {
            log.error((Object)"Should not have timed out here!", (Throwable)toe);
        }
        catch (InterruptedException ie) {
            log.error((Object)"Should not have been interrupted here!", (Throwable)ie);
        }
    }
}

