/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cron.test.scheduling.beans;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.time.Instant;
import org.jboss.seam.cron.api.scheduling.Every;
import org.jboss.seam.cron.api.scheduling.Interval;
import org.jboss.seam.cron.api.scheduling.Trigger;
import org.jboss.seam.cron.impl.scheduling.exception.InternalException;

@ApplicationScoped
public class IncrementalScheduledBean {
    private Instant lastTriggerSecond = null;
    private final int tolleranceSeconds = 1;
    private Exception errorDetected = null;
    private boolean wasEventObserved = false;

    public void every40Seconds(@Observes @Every(nth=40, value=Interval.SECOND) Trigger t) throws Exception {
        this.wasEventObserved = true;
        Instant newInstant = Instant.millis((long)t.getTimeFired());
        if (this.lastTriggerSecond != null && Math.abs(this.lastTriggerSecond.getEpochSeconds() - (newInstant.getEpochSeconds() - 40L)) > 1L) {
            String errorMessage = "Tick interval was not as per configuration. Previous tick was at " + this.lastTriggerSecond.getEpochSeconds() + " and this one was at " + newInstant.getEpochSeconds();
            System.out.println("ERROR: " + errorMessage);
            this.errorDetected = new InternalException(errorMessage);
        }
        this.lastTriggerSecond = newInstant;
    }

    public Exception getErrorDetected() {
        return this.errorDetected;
    }

    public boolean isWasEventObserved() {
        return this.wasEventObserved;
    }
}

