/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cron.test.scheduling.beans;

import java.util.Calendar;
import java.util.Date;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.jboss.logging.Logger;
import org.jboss.seam.cron.api.scheduling.Every;
import org.jboss.seam.cron.api.scheduling.Interval;
import org.jboss.seam.cron.api.scheduling.Scheduled;
import org.jboss.seam.cron.api.scheduling.Trigger;
import org.jboss.seam.cron.test.scheduling.beans.Frequent;

@ApplicationScoped
public class ScheduledBean {
    private final Logger log = Logger.getLogger(ScheduledBean.class);
    private boolean scheduledEventObserved = false;
    private boolean namedEventObserved = false;
    private boolean typesafeEventObserved = false;
    private boolean firedCorrectly = true;
    private boolean everySecondEventObserved = false;

    public void onSchedule(@Observes @Scheduled(value="*/5 * * ? * *") Trigger event) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(event.getTimeFired());
        this.firedCorrectly &= c.get(13) % 5 == 0;
        this.log.info((Object)("Scheduled event fired at " + c.getTime()));
        this.scheduledEventObserved = true;
    }

    public void onNamedSchedule(@Observes @Scheduled(value="test.one") Trigger event) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(event.getTimeFired());
        this.firedCorrectly &= c.get(13) % 5 == 0;
        this.log.info((Object)("Named event fired at " + c.getTime()));
        this.namedEventObserved = true;
    }

    public void onTypesafeSchedule(@Observes @Frequent Trigger event) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(event.getTimeFired());
        this.firedCorrectly &= c.get(13) % 5 == 0;
        this.log.info((Object)("Typesafe event fired at " + c.getTime()));
        this.typesafeEventObserved = true;
    }

    public void onEverySecondSchedule(@Observes @Every(value=Interval.SECOND) Trigger event) {
        this.log.info((Object)("Every second event fired at " + new Date(event.getTimeFired())));
        this.everySecondEventObserved = true;
    }

    public boolean isScheduledEventObserved() {
        return this.scheduledEventObserved;
    }

    public boolean isNamedEventObserved() {
        return this.namedEventObserved;
    }

    public boolean isTypesafeEventObserved() {
        return this.typesafeEventObserved;
    }

    public boolean isFiredCorrectly() {
        return this.firedCorrectly;
    }

    public boolean isEverySecondEventObserved() {
        return this.everySecondEventObserved;
    }
}

