/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.cron.test.scheduling.tck;

import javax.inject.Inject;
import junit.framework.Assert;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.logging.Logger;
import org.jboss.seam.cron.spi.scheduling.CronSchedulingProvider;
import org.jboss.seam.cron.test.scheduling.SeamCronSchedulingTestBase;
import org.jboss.seam.cron.test.scheduling.beans.ScheduledBean;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class SeamCronSchedulingTCKTest {
    private static final int MAX_TIME_TO_WAIT = 20000;
    private static final int SLEEP_TIME = 2000;
    private static final Logger log = Logger.getLogger(SeamCronSchedulingTCKTest.class);
    @Inject
    ScheduledBean bean;
    @Inject
    CronSchedulingProvider cronSchedProv;

    public static JavaArchive createSchedulingTckTestArchive() {
        return (JavaArchive)SeamCronSchedulingTestBase.createSchedulingTestArchive().addPackage(SeamCronSchedulingTCKTest.class.getPackage());
    }

    @Test
    public void testEventsGetsFired() {
        log.info((Object)"Testing schedule observer receiving events");
        assert (!this.bean.isScheduledEventObserved());
        assert (!this.bean.isNamedEventObserved());
        assert (!this.bean.isTypesafeEventObserved());
        assert (!this.bean.isEverySecondEventObserved());
        int totalTimeWaited = 0;
        while (!(this.bean.isScheduledEventObserved() && this.bean.isNamedEventObserved() && this.bean.isEverySecondEventObserved() && this.bean.isTypesafeEventObserved() || totalTimeWaited >= 20000)) {
            try {
                log.info((Object)("Sleeping for a few seconds, waiting for all events to fire. Waited for " + totalTimeWaited + "ms so far ..."));
                totalTimeWaited += 2000;
                Thread.sleep(2000L);
            }
            catch (InterruptedException ex) {
                log.error((Object)"Thread was woken up while sleeping");
                ex.printStackTrace();
                Assert.fail((String)"Thread was woken up while sleeping. Why?");
            }
        }
        assert (this.bean.isScheduledEventObserved());
        assert (this.bean.isNamedEventObserved());
        assert (this.bean.isEverySecondEventObserved());
        assert (this.bean.isFiredCorrectly());
        assert (this.bean.isTypesafeEventObserved());
    }
}

