/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.util;

import com.google.common.base.Strings;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.PartialResponseWriter;
import org.richfaces.application.ServiceTracker;
import org.richfaces.context.ExtendedPartialViewContext;
import org.richfaces.renderkit.AjaxDataSerializer;

public final class CoreAjaxRendererUtils {
    public static final String AJAX_PROCESS_ATTRIBUTE = "process";
    public static final String AJAX_REGIONS_ATTRIBUTE = "reRender";
    private static final String EXTENSION_ID = "org.richfaces.extension";
    private static final String BEFOREDOMUPDATE_ELEMENT_NAME = "beforedomupdate";
    private static final String COMPLETE_ELEMENT_NAME = "complete";
    private static final String DATA_ELEMENT_NAME = "data";
    private static final String COMPONENT_DATA_ELEMENT_NAME = "componentData";
    private static final Pattern ID_SPLIT_PATTERN = Pattern.compile("\\s*(\\s|,)\\s*");

    private CoreAjaxRendererUtils() {
    }

    private static void startExtensionElementIfNecessary(PartialResponseWriter partialResponseWriter, Map<String, String> attributes, boolean[] writingState) throws IOException {
        if (!writingState[0]) {
            writingState[0] = true;
            partialResponseWriter.startExtension(attributes);
        }
    }

    private static void endExtensionElementIfNecessary(PartialResponseWriter partialResponseWriter, boolean[] writingState) throws IOException {
        if (writingState[0]) {
            writingState[0] = false;
            partialResponseWriter.endExtension();
        }
    }

    public static void renderAjaxExtensions(FacesContext facesContext, UIComponent component) throws IOException {
        Map<String, Object> responseComponentDataMap;
        Object responseData;
        String string;
        Object oncomplete;
        String string2;
        ExtendedPartialViewContext partialContext = ExtendedPartialViewContext.getInstance(facesContext);
        Map<String, String> attributes = Collections.singletonMap("id", facesContext.getExternalContext().encodeNamespace(EXTENSION_ID));
        PartialResponseWriter writer = facesContext.getPartialViewContext().getPartialResponseWriter();
        boolean[] writingState = new boolean[]{false};
        Object onbeforedomupdate = partialContext.getOnbeforedomupdate();
        if (onbeforedomupdate != null && (string2 = onbeforedomupdate.toString()).length() != 0) {
            CoreAjaxRendererUtils.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(BEFOREDOMUPDATE_ELEMENT_NAME, component);
            writer.writeText(onbeforedomupdate, null);
            writer.endElement(BEFOREDOMUPDATE_ELEMENT_NAME);
        }
        if ((oncomplete = partialContext.getOncomplete()) != null && (string = oncomplete.toString()).length() != 0) {
            CoreAjaxRendererUtils.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(COMPLETE_ELEMENT_NAME, component);
            writer.writeText(oncomplete, null);
            writer.endElement(COMPLETE_ELEMENT_NAME);
        }
        if ((responseData = partialContext.getResponseData()) != null) {
            CoreAjaxRendererUtils.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(DATA_ELEMENT_NAME, component);
            AjaxDataSerializer serializer = ServiceTracker.getService(facesContext, AjaxDataSerializer.class);
            writer.writeText((Object)serializer.asString(responseData), null);
            writer.endElement(DATA_ELEMENT_NAME);
        }
        if ((responseComponentDataMap = partialContext.getResponseComponentDataMap()) != null && !responseComponentDataMap.isEmpty()) {
            CoreAjaxRendererUtils.startExtensionElementIfNecessary(writer, attributes, writingState);
            writer.startElement(COMPONENT_DATA_ELEMENT_NAME, component);
            AjaxDataSerializer serializer = ServiceTracker.getService(facesContext, AjaxDataSerializer.class);
            writer.writeText((Object)serializer.asString(responseComponentDataMap), null);
            writer.endElement(COMPONENT_DATA_ELEMENT_NAME);
        }
        CoreAjaxRendererUtils.endExtensionElementIfNecessary(writer, writingState);
    }

    public static Set<String> getAjaxAreas(UIComponent uiComponent) {
        Object areas = uiComponent.getAttributes().get(AJAX_REGIONS_ATTRIBUTE);
        return CoreAjaxRendererUtils.asIdsSet(areas);
    }

    public static Set<String> getAjaxAreasToProcess(UIComponent component) {
        Object areas = component.getAttributes().get(AJAX_PROCESS_ATTRIBUTE);
        return CoreAjaxRendererUtils.asIdsSet(areas);
    }

    public static Set<String> asSimpleSet(Object valueToSet) {
        return CoreAjaxRendererUtils.asSet(valueToSet);
    }

    public static Set<String> asIdsSet(Object valueToSet) {
        return CoreAjaxRendererUtils.asSet(valueToSet);
    }

    private static Set<String> asSet(Object valueToSet) {
        if (null != valueToSet) {
            if (valueToSet instanceof Set) {
                return new LinkedHashSet<String>((Set)valueToSet);
            }
            if (valueToSet instanceof Collection) {
                return new LinkedHashSet<String>((Collection)valueToSet);
            }
            if (Object[].class.isAssignableFrom(valueToSet.getClass())) {
                return new LinkedHashSet<String>(Arrays.asList((String[])valueToSet));
            }
            if (valueToSet instanceof String) {
                String areasString = ((String)valueToSet).trim();
                if (areasString.contains(",") || areasString.contains(" ")) {
                    String[] values = ID_SPLIT_PATTERN.split(areasString);
                    LinkedHashSet<String> result = new LinkedHashSet<String>(values.length);
                    for (String value : values) {
                        if (Strings.isNullOrEmpty((String)value)) continue;
                        result.add(value);
                    }
                    return result;
                }
                LinkedHashSet<String> areasSet = new LinkedHashSet<String>(5);
                if (!Strings.isNullOrEmpty((String)areasString)) {
                    areasSet.add(areasString);
                }
                return areasSet;
            }
        }
        return null;
    }
}

