/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.Closeable;
import java.io.DataInput;
import java.io.IOException;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.callback.CallbackHandler;
import org.jboss.as.protocol.ProtocolChannelClient;
import org.jboss.as.protocol.ProtocolMessages;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.AbstractManagementRequest;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementChannelHandler;
import org.jboss.as.protocol.mgmt.ManagementClientChannelStrategy;
import org.jboss.as.protocol.mgmt.ManagementRequest;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.server.ServerMessages;
import org.jboss.remoting3.Channel;
import org.jboss.remoting3.CloseHandler;
import org.jboss.remoting3.Connection;
import org.xnio.OptionMap;

public class HostControllerServerConnection
extends ManagementClientChannelStrategy {
    private static final String SERVER_CHANNEL_TYPE = "server";
    private final String serverProcessName;
    private final ProtocolChannelClient.Configuration configuration;
    private final ManagementChannelHandler channelHandler;
    private volatile Connection connection;
    private volatile Channel channel;

    public HostControllerServerConnection(String serverProcessName, ProtocolChannelClient.Configuration configuration, ExecutorService executorService) {
        this.serverProcessName = serverProcessName;
        this.configuration = configuration;
        this.channelHandler = new ManagementChannelHandler((ManagementClientChannelStrategy)this, executorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connect(CallbackHandler callbackHandler, ActiveOperation.CompletedCallback<Void> callback) throws IOException {
        boolean ok = false;
        try {
            this.openChannel(callbackHandler);
            this.channelHandler.executeRequest((ManagementRequest)new ServerRegisterRequest(), null, callback);
            ok = true;
        }
        finally {
            if (!ok) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void reconnect(URI connectionURI, CallbackHandler callbackHandler, ActiveOperation.CompletedCallback<Boolean> callback) throws IOException {
        boolean ok = false;
        try {
            this.configuration.setUri(connectionURI);
            this.openChannel(callbackHandler);
            this.channelHandler.executeRequest((ManagementRequest)new ServerReconnectRequest(), null, callback);
            ok = true;
        }
        finally {
            if (!ok) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Channel getChannel() throws IOException {
        Channel channel = this.channel;
        if (channel == null) {
            HostControllerServerConnection hostControllerServerConnection = this;
            synchronized (hostControllerServerConnection) {
                if (this.channel == null) {
                    throw ProtocolMessages.MESSAGES.channelClosed();
                }
            }
        }
        return channel;
    }

    public void close() throws IOException {
        StreamUtils.safeClose((Closeable)this.channel);
        StreamUtils.safeClose((Closeable)this.connection);
    }

    public ManagementChannelHandler getChannelHandler() {
        return this.channelHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void openChannel(CallbackHandler callbackHandler) throws IOException {
        boolean ok = false;
        try {
            ProtocolChannelClient client = ProtocolChannelClient.create((ProtocolChannelClient.Configuration)this.configuration);
            this.connection = client.connectSync(callbackHandler, null, HostControllerServerConnection.getAcceptingSSLContext());
            this.connection.addCloseHandler((CloseHandler)new CloseHandler<Connection>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleClose(Connection closed, IOException exception) {
                    1 var3_3 = this;
                    synchronized (var3_3) {
                        if (HostControllerServerConnection.this.connection == closed) {
                            HostControllerServerConnection.this.connection = null;
                        }
                    }
                }
            });
            this.channel = (Channel)this.connection.openChannel(SERVER_CHANNEL_TYPE, OptionMap.EMPTY).get();
            this.channel.addCloseHandler((CloseHandler)new CloseHandler<Channel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handleClose(Channel closed, IOException exception) {
                    HostControllerServerConnection.this.channelHandler.handleChannelClosed(closed, exception);
                    2 var3_3 = this;
                    synchronized (var3_3) {
                        if (HostControllerServerConnection.this.channel == closed) {
                            HostControllerServerConnection.this.channel = null;
                        }
                    }
                }
            });
            this.channel.receiveMessage(this.channelHandler.getReceiver());
            ok = true;
        }
        finally {
            if (!ok) {
                StreamUtils.safeClose((Closeable)this.channel);
                StreamUtils.safeClose((Closeable)this.connection);
            }
        }
    }

    private static SSLContext getAcceptingSSLContext() throws IOException {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = new TrustManager[]{new X509TrustManager(){

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public void checkServerTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }
            }};
            sslContext.init(null, trustManagers, null);
            return sslContext;
        }
        catch (GeneralSecurityException e) {
            throw ServerMessages.MESSAGES.unableToInitialiseSSLContext(e.getMessage());
        }
    }

    public class ServerReconnectRequest
    extends AbstractManagementRequest<Boolean, Void> {
        public byte getOperationType() {
            return 3;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Boolean> resultHandler, ManagementRequestContext<Void> context, FlushableDataOutput output) throws IOException {
            output.write(1);
            output.writeUTF(HostControllerServerConnection.this.serverProcessName);
        }

        public void handleRequest(DataInput input, final ActiveOperation.ResultHandler<Boolean> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            final byte param = input.readByte();
            context.executeAsync((ManagementRequestContext.AsyncTask)new ManagementRequestContext.AsyncTask<Void>(){

                public void execute(ManagementRequestContext<Void> voidManagementRequestContext) throws Exception {
                    if (param == 33) {
                        resultHandler.done((Object)Boolean.TRUE);
                    } else {
                        resultHandler.done((Object)Boolean.FALSE);
                    }
                }
            });
        }
    }

    private class ServerRegisterRequest
    extends AbstractManagementRequest<Void, Void> {
        private ServerRegisterRequest() {
        }

        public byte getOperationType() {
            return 0;
        }

        protected void sendRequest(ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext, FlushableDataOutput output) throws IOException {
            output.write(1);
            output.writeUTF(HostControllerServerConnection.this.serverProcessName);
        }

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<Void> resultHandler, ManagementRequestContext<Void> voidManagementRequestContext) throws IOException {
            resultHandler.done(null);
        }
    }
}

