/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.mgmt.domain;

import java.io.File;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.repository.DeploymentFileRepository;
import org.jboss.as.repository.LocalDeploymentFileRepository;
import org.jboss.as.server.ServerMessages;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class RemoteFileRepository
implements DeploymentFileRepository,
Service<RemoteFileRepository> {
    public static final ServiceName SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"host", "server", "remote", "repository"});
    final File localDeploymentFolder;
    final DeploymentFileRepository localRepository;
    private volatile RemoteFileRepositoryExecutor remoteFileRepositoryExecutor;

    private RemoteFileRepository(File localDeploymentFolder) {
        this.localDeploymentFolder = localDeploymentFolder;
        this.localRepository = new LocalDeploymentFileRepository(localDeploymentFolder);
    }

    public static RemoteFileRepository addService(ServiceTarget serviceTarget, File localDeploymentFolder) {
        RemoteFileRepository repo = new RemoteFileRepository(localDeploymentFolder);
        serviceTarget.addService(SERVICE_NAME, (Service)repo).install();
        return repo;
    }

    public RemoteFileRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public final File[] getDeploymentFiles(byte[] deploymentHash) {
        String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
        return this.getFile(hex, (byte)40).listFiles();
    }

    public File getDeploymentRoot(byte[] deploymentHash) {
        String hex = deploymentHash == null ? "" : HashUtil.bytesToHexString((byte[])deploymentHash);
        return this.getFile(hex, (byte)40);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getFile(String relativePath, byte repoId) {
        RemoteFileRepositoryExecutor remoteFileRepositoryExecutor = this.remoteFileRepositoryExecutor;
        if (remoteFileRepositoryExecutor == null) {
            RemoteFileRepository remoteFileRepository = this;
            synchronized (remoteFileRepository) {
                remoteFileRepositoryExecutor = this.remoteFileRepositoryExecutor;
                try {
                    while (remoteFileRepositoryExecutor == null) {
                        this.wait();
                        remoteFileRepositoryExecutor = this.remoteFileRepositoryExecutor;
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
        if (remoteFileRepositoryExecutor == null) {
            throw ServerMessages.MESSAGES.couldNotFindHcFileRepositoryConnection();
        }
        return remoteFileRepositoryExecutor.getFile(relativePath, repoId, this.localDeploymentFolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRemoteFileRepositoryExecutor(RemoteFileRepositoryExecutor remoteFileRepositoryExecutor) {
        RemoteFileRepository remoteFileRepository = this;
        synchronized (remoteFileRepository) {
            this.remoteFileRepositoryExecutor = remoteFileRepositoryExecutor;
            this.notifyAll();
        }
    }

    public void deleteDeployment(byte[] deploymentHash) {
        this.localRepository.deleteDeployment(deploymentHash);
    }

    static interface RemoteFileRepositoryExecutor {
        public File getFile(String var1, byte var2, File var3);
    }
}

