/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.apache.wicket.AbortException;
import org.apache.wicket.Application;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.SharedResources;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.markup.html.WebResource;
import org.apache.wicket.protocol.http.WebRequestCycle;
import org.apache.wicket.protocol.http.servlet.AbortWithWebErrorCodeException;
import org.apache.wicket.util.lang.Classes;
import org.apache.wicket.util.lang.PackageName;
import org.apache.wicket.util.lang.Packages;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.string.Strings;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.watch.IModifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageResource
extends WebResource
implements IModifiable,
IPackageResourceGuard {
    @Deprecated
    public static final Pattern EXTENSION_CSS = Pattern.compile(".*\\.css");
    @Deprecated
    public static final Pattern EXTENSION_JS = Pattern.compile(".*\\.js");
    private static final Logger log = LoggerFactory.getLogger(PackageResource.class);
    private static final long serialVersionUID = 1L;
    private final String absolutePath;
    private Locale locale;
    private final String path;
    private final String scopeName;
    private final String style;
    private transient Time lastModifiedTime = null;
    private transient long lastModifiedTimeUpdate = 0L;

    @Deprecated
    public static void bind(Application application, Class<?> scope, Pattern pattern) {
    }

    @Deprecated
    public static void bind(Application application, Class<?> scope, Pattern pattern, boolean recurse) {
    }

    public static void bind(Application application, Class<?> scope, String name) {
        PackageResource.bind(application, scope, name, null, null);
    }

    public static void bind(Application application, Class<?> scope, String name, Locale locale) {
        PackageResource.bind(application, scope, name, locale, null);
    }

    public static void bind(Application application, Class<?> scope, String name, Locale locale, String style) {
        if (name == null) {
            throw new IllegalArgumentException("argument name may not be null");
        }
        if (!PackageResource.exists(scope, name, locale, style)) {
            throw new IllegalArgumentException("no package resource was found for scope " + scope + ", name " + name + ", locale " + locale + ", style " + style);
        }
        PackageResource packageResource = PackageResource.get(scope, name, locale, style);
        SharedResources sharedResources = Application.get().getSharedResources();
        sharedResources.add(scope, name, locale, style, packageResource);
    }

    public static boolean exists(Class<?> scope, String path, Locale locale, String style) {
        String absolutePath = Packages.absolutePath(scope, path);
        return Application.get().getResourceSettings().getResourceStreamLocator().locate(scope, absolutePath, style, locale, null) != null;
    }

    @Deprecated
    public static PackageResource[] get(Class<?> scope, Pattern pattern) {
        return PackageResource.get(scope, pattern, false);
    }

    @Deprecated
    public static PackageResource[] get(Class<?> scope, Pattern pattern, boolean recurse) {
        ArrayList<PackageResource> resources = new ArrayList<PackageResource>();
        String packageRef = ((Object)Strings.replaceAll(PackageName.forClass(scope).getName(), ".", "/")).toString();
        ClassLoader loader = scope.getClassLoader();
        try {
            Enumeration<URL> packageResources = loader.getResources(packageRef);
            while (packageResources.hasMoreElements()) {
                File basedir;
                URI uri;
                URL resource = packageResources.nextElement();
                URLConnection connection = resource.openConnection();
                if (connection instanceof JarURLConnection) {
                    JarFile jf = ((JarURLConnection)connection).getJarFile();
                    PackageResource.scanJarFile(scope, pattern, recurse, resources, packageRef, jf);
                    continue;
                }
                String absolutePath = scope.getResource("").toExternalForm();
                try {
                    uri = new URI(absolutePath);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e);
                }
                try {
                    basedir = new File(uri);
                }
                catch (IllegalArgumentException e) {
                    log.debug("Can't construct the uri as a file: " + absolutePath);
                    String jarZipPart = uri.getSchemeSpecificPart();
                    String lowerJarZipPart = jarZipPart.toLowerCase();
                    int index = lowerJarZipPart.indexOf(".zip");
                    if (index == -1) {
                        index = lowerJarZipPart.indexOf(".jar");
                    }
                    if (index == -1) {
                        throw e;
                    }
                    String filename = jarZipPart.substring(0, index + 4);
                    log.debug("trying the filename: " + filename + " to load as a zip/jar.");
                    JarFile jarFile = new JarFile(filename, false);
                    PackageResource.scanJarFile(scope, pattern, recurse, resources, packageRef, jarFile);
                    return resources.toArray(new PackageResource[resources.size()]);
                }
                if (basedir.isDirectory()) continue;
                throw new IllegalStateException("unable to read resources from directory " + basedir);
            }
        }
        catch (IOException e) {
            throw new WicketRuntimeException(e);
        }
        return resources.toArray(new PackageResource[resources.size()]);
    }

    public static PackageResource get(Class<?> scope, String path) {
        return PackageResource.get(scope, path, null, null);
    }

    public static PackageResource get(Class<?> scope, String path, Locale locale, String style) {
        SharedResources sharedResources = Application.get().getSharedResources();
        PackageResource resource = (PackageResource)sharedResources.get(scope, path, locale, style, true);
        if (resource == null) {
            resource = PackageResource.newPackageResource(scope, path, locale, style);
            Application.get().getSharedResources().add(scope, path, locale, style, resource);
        }
        return resource;
    }

    protected static PackageResource newPackageResource(Class<?> scope, String path, Locale locale, String style) {
        return new PackageResource(scope, path, locale, style);
    }

    private static void scanJarFile(Class<?> scope, Pattern pattern, boolean recurse, List<PackageResource> resources, String packageRef, JarFile jf) {
        Enumeration<JarEntry> enumeration = jf.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry je = enumeration.nextElement();
            String name = je.getName();
            if (!name.startsWith(packageRef) || !pattern.matcher(name = name.substring(packageRef.length() + 1)).matches() || !recurse && name.indexOf(47) != -1) continue;
            resources.add(PackageResource.get(scope, name, null, null));
        }
    }

    protected PackageResource(Class<?> scope, String path, Locale locale, String style) {
        this.absolutePath = Packages.absolutePath(scope, path);
        if (!this.accept(scope, path)) {
            throw new PackageResourceBlockedException("Access denied to (static) package resource " + this.absolutePath + ". See IPackageResourceGuard");
        }
        this.scopeName = scope.getName();
        this.path = path;
        this.locale = locale;
        this.style = style;
        if (locale != null) {
            this.getResourceStream(false);
            this.invalidate();
        }
    }

    public final String getAbsolutePath() {
        return this.absolutePath;
    }

    public final Locale getLocale() {
        return this.locale;
    }

    public final String getPath() {
        return this.path;
    }

    @Override
    public IResourceStream getResourceStream() {
        return this.getResourceStream(true);
    }

    public IResourceStream getResourceStream(boolean failOnError) {
        IResourceStream resourceStream = Application.get().getResourceSettings().getResourceStreamLocator().locate(this.getScope(), this.absolutePath, this.style, this.locale, null);
        if (resourceStream == null) {
            if (!failOnError) {
                return null;
            }
            String msg = "Unable to find package resource [path = " + this.absolutePath + ", style = " + this.style + ", locale = " + this.locale + "]";
            log.warn(msg);
            if (RequestCycle.get() instanceof WebRequestCycle) {
                throw new AbortWithWebErrorCodeException(404, msg);
            }
            throw new AbortException();
        }
        this.locale = resourceStream.getLocale();
        if (resourceStream != null) {
            this.lastModifiedTime = resourceStream.lastModifiedTime();
            this.lastModifiedTimeUpdate = System.currentTimeMillis();
        }
        return resourceStream;
    }

    public final Class<?> getScope() {
        return Classes.resolveClass(this.scopeName);
    }

    public final String getStyle() {
        return this.style;
    }

    @Override
    public Time lastModifiedTime() {
        if (this.lastModifiedTimeUpdate == 0L || this.lastModifiedTimeUpdate < System.currentTimeMillis() - 300000L) {
            IResourceStream resourceStream = this.getResourceStream(false);
            if (resourceStream != null) {
                this.lastModifiedTime = resourceStream.lastModifiedTime();
            }
            this.lastModifiedTimeUpdate = System.currentTimeMillis();
        }
        return this.lastModifiedTime;
    }

    @Override
    public boolean accept(Class<?> scope, String path) {
        IPackageResourceGuard guard = Application.get().getResourceSettings().getPackageResourceGuard();
        return guard.accept(scope, path);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append('[').append(this.getClass().getSimpleName()).append(' ').append("name = ").append(this.getPath()).append(", scope = ").append(this.scopeName).append(", locale = ").append(this.locale).append(", style = ").append(this.style).append(']');
        return result.toString();
    }

    public static final class PackageResourceBlockedException
    extends WicketRuntimeException {
        private static final long serialVersionUID = 1L;

        public PackageResourceBlockedException(String message) {
            super(message);
        }
    }
}

