/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.resolver;

import org.apache.wicket.MarkupContainer;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.WicketTag;
import org.apache.wicket.markup.html.internal.Enclosure;
import org.apache.wicket.markup.resolver.IComponentResolver;

public class EnclosureResolver
implements IComponentResolver {
    private static final long serialVersionUID = 1L;

    public boolean resolve(MarkupContainer container, MarkupStream markupStream, ComponentTag tag) {
        if (tag instanceof WicketTag && ((WicketTag)tag).isEnclosureTag()) {
            CharSequence wicketId = tag.getString("wicket:id");
            String id = null;
            if (wicketId != null) {
                id = ((Object)wicketId).toString();
            }
            if (id == null) {
                id = "enclosure-" + container.getPage().getAutoIndex();
            }
            Enclosure enclosure = new Enclosure(id, tag.getString("child"));
            container.autoAdd(enclosure, markupStream);
            return true;
        }
        return false;
    }
}

