/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.transformer;

import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.markup.transformer.AbstractOutputTransformerContainer;
import org.apache.wicket.markup.transformer.XsltTransformer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsltOutputTransformerContainer
extends AbstractOutputTransformerContainer {
    private static final long serialVersionUID = 1L;
    private final String xslFile;

    public XsltOutputTransformerContainer(String id, IModel<?> model, String xslFilePath) {
        super(id);
        this.xslFile = xslFilePath;
        this.setTransformBodyOnly(false);
        this.add(new AttributeModifier("xmlns:wicket", true, new Model<String>("http://wicket.apache.org/dtds.data/wicket-xhtml1.3-strict.dtd")));
    }

    public XsltOutputTransformerContainer(String id, IModel<?> model) {
        this(id, model, null);
    }

    public XsltOutputTransformerContainer(String id) {
        this(id, null, null);
    }

    @Override
    public String getMarkupType() {
        return "xsl";
    }

    @Override
    public CharSequence transform(Component component, CharSequence output) throws Exception {
        return new XsltTransformer(this.xslFile).transform(component, output);
    }
}

