/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http;

import javax.servlet.http.HttpServletResponse;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.protocol.http.WebResponse;
import org.apache.wicket.util.string.AppendingStringBuffer;

public class BufferedWebResponse
extends WebResponse {
    private String redirectURL;
    private AppendingStringBuffer buffer = new AppendingStringBuffer(4096);

    BufferedWebResponse() {
    }

    public BufferedWebResponse(HttpServletResponse httpServletResponse) {
        super(httpServletResponse);
    }

    public void close() {
        if (this.redirectURL != null) {
            super.redirect(this.redirectURL);
        } else if (this.buffer.length() != 0) {
            super.write(this.buffer);
        }
    }

    public void reset() {
        this.redirectURL = null;
        this.buffer.clear();
    }

    public final void redirect(String url) {
        if (this.redirectURL != null) {
            throw new WicketRuntimeException("Already redirecting to '" + this.redirectURL + "'. Cannot redirect more than once");
        }
        this.redirectURL = ((Object)this.encodeURL(url)).toString();
    }

    public void write(CharSequence string) {
        this.buffer.append(string);
    }

    public final void filter() {
        if (this.redirectURL == null && this.buffer.length() != 0) {
            this.buffer = this.filter(this.buffer);
        }
    }

    public String toString() {
        return this.buffer.toString();
    }
}

