/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.pagestore;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.wicket.util.collections.IntHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageWindowManager
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<PageWindowInternal> windows = new ArrayList<PageWindowInternal>();
    private IntHashMap<List<Integer>> idToWindowIndices = null;
    private int indexPointer = -1;
    private int totalSize = 0;
    private final int maxSize;

    private void putWindowIndex(int pageId, int windowIndex) {
        if (pageId != -1 && this.idToWindowIndices != null) {
            List<Integer> indices = this.idToWindowIndices.get(pageId);
            Integer index = new Integer(windowIndex);
            if (indices == null) {
                indices = new ArrayList<Integer>();
                indices.add(index);
                this.idToWindowIndices.put(pageId, indices);
            } else if (!indices.contains(index)) {
                indices.add(index);
            }
        }
    }

    private void removeWindowIndex(int pageId, int windowIndex) {
        List<Integer> indices;
        if (pageId != -1 && this.idToWindowIndices != null && (indices = this.idToWindowIndices.get(pageId)) != null) {
            indices.remove(new Integer(windowIndex));
        }
    }

    private void rebuildIndices() {
        this.idToWindowIndices = new IntHashMap();
        for (int i = 0; i < this.windows.size(); ++i) {
            PageWindowInternal window = this.windows.get(i);
            this.putWindowIndex(window.pageId, i);
        }
    }

    private int getWindowIndex(List<Integer> indices, int pageId, int versionNumber, int ajaxVersionNumber) {
        int result;
        block3: {
            block5: {
                block4: {
                    result = -1;
                    if (versionNumber == -1 || ajaxVersionNumber == -1) break block4;
                    for (int currentIndex : indices) {
                        PageWindowInternal window = this.windows.get(currentIndex);
                        if (window.pageId != pageId || window.versionNumber != versionNumber || window.ajaxVersionNumber != ajaxVersionNumber) continue;
                        result = currentIndex;
                        break block3;
                    }
                    break block3;
                }
                if (versionNumber != -1) break block5;
                for (int currentIndex : indices) {
                    PageWindowInternal window = this.windows.get(currentIndex);
                    if (window.pageId != pageId || !(result == -1 || currentIndex <= this.indexPointer && result > this.indexPointer || currentIndex > result && currentIndex <= this.indexPointer) && (currentIndex <= result || result <= this.indexPointer)) continue;
                    result = currentIndex;
                }
                break block3;
            }
            if (ajaxVersionNumber != -1) break block3;
            short lastAjaxVersion = -1;
            for (int currentIndex : indices) {
                PageWindowInternal window = this.windows.get(currentIndex);
                if (window.pageId != pageId || window.versionNumber != versionNumber || window.ajaxVersionNumber <= lastAjaxVersion) continue;
                result = currentIndex;
                lastAjaxVersion = window.ajaxVersionNumber;
            }
        }
        return result;
    }

    private int getWindowIndex(int pageId, int versionNumber, int ajaxVersionNumber) {
        List<Integer> indices;
        int index = -1;
        if (this.idToWindowIndices == null) {
            this.rebuildIndices();
        }
        if ((indices = this.idToWindowIndices.get(pageId)) != null) {
            index = this.getWindowIndex(indices, pageId, versionNumber, ajaxVersionNumber);
        }
        return index;
    }

    private int incrementIndexPointer() {
        this.indexPointer = this.maxSize > 0 && this.totalSize >= this.maxSize && this.indexPointer == this.windows.size() - 1 ? 0 : ++this.indexPointer;
        return this.indexPointer;
    }

    private int getWindowFileOffset(int index) {
        if (index > 0) {
            PageWindowInternal window = this.windows.get(index - 1);
            return window.filePartOffset + window.filePartSize;
        }
        return 0;
    }

    private void splitWindow(int index, int size) {
        PageWindowInternal window = this.windows.get(index);
        int delta = window.filePartSize - size;
        if (index == this.windows.size() - 1) {
            this.totalSize -= delta;
            window.filePartSize = size;
        } else if (window.filePartSize != size) {
            PageWindowInternal newWindow = new PageWindowInternal();
            newWindow.pageId = -1;
            window.filePartSize = size;
            this.windows.add(index + 1, newWindow);
            newWindow.filePartOffset = this.getWindowFileOffset(index + 1);
            newWindow.filePartSize = delta;
        }
        this.idToWindowIndices = null;
    }

    private void mergeWindowWithNext(int index) {
        if (index < this.windows.size() - 1) {
            PageWindowInternal window = this.windows.get(index);
            PageWindowInternal next = this.windows.get(index + 1);
            window.filePartSize += next.filePartSize;
            this.windows.remove(index + 1);
            this.idToWindowIndices = null;
        }
    }

    private void adjustWindowSize(int index, int size) {
        PageWindowInternal window = this.windows.get(index);
        if (index == this.windows.size() - 1) {
            int delta = size - window.filePartSize;
            this.totalSize += delta;
            window.filePartSize = size;
        } else {
            while (window.filePartSize < size && index < this.windows.size() - 1) {
                this.mergeWindowWithNext(index);
            }
            if (window.filePartSize < size) {
                int delta = size - window.filePartSize;
                this.totalSize += delta;
                window.filePartSize = size;
            } else {
                this.splitWindow(index, size);
            }
        }
        window.pageId = -1;
    }

    private PageWindowInternal allocatePageWindow(int index, int size) {
        PageWindowInternal window;
        if (index == this.windows.size()) {
            window = new PageWindowInternal();
            window.filePartOffset = this.getWindowFileOffset(index);
            this.totalSize += size;
            window.filePartSize = size;
            this.windows.add(window);
        } else {
            window = this.windows.get(index);
            if (window.filePartSize != size) {
                this.adjustWindowSize(index, size);
            }
        }
        return window;
    }

    public PageWindow createPageWindow(int pageId, int versionNumber, int ajaxVersionNumber, int size) {
        int index = this.getWindowIndex(pageId, versionNumber, ajaxVersionNumber);
        if (index != -1) {
            this.removeWindowIndex(pageId, index);
            this.windows.get(index).pageId = -1;
        }
        if (index == -1 || index != this.indexPointer) {
            index = this.incrementIndexPointer();
        }
        PageWindowInternal window = this.allocatePageWindow(index, size);
        window.pageId = pageId;
        window.versionNumber = (short)versionNumber;
        window.ajaxVersionNumber = (short)ajaxVersionNumber;
        this.putWindowIndex(pageId, index);
        return new PageWindow(window);
    }

    public PageWindow getPageWindow(int pageId, int versionNumber, int ajaxVersionNumber) {
        int index = this.getWindowIndex(pageId, versionNumber, ajaxVersionNumber);
        if (index != -1) {
            return new PageWindow(this.windows.get(index));
        }
        return null;
    }

    public void removePage(int pageId, int versionNumber, int ajaxVersionNumber) {
        int index = this.getWindowIndex(pageId, versionNumber, ajaxVersionNumber);
        if (index != -1) {
            PageWindowInternal window = this.windows.get(index);
            this.removeWindowIndex(pageId, index);
            if (index == this.windows.size() - 1) {
                this.windows.remove(index);
                this.totalSize -= window.filePartSize;
                if (this.indexPointer == index) {
                    --this.indexPointer;
                }
            } else {
                window.pageId = -1;
            }
        }
    }

    public void removePage(int pageId) {
        List<Integer> indicesList;
        if (this.idToWindowIndices == null) {
            this.rebuildIndices();
        }
        if ((indicesList = this.idToWindowIndices.get(pageId)) != null) {
            Object[] indices = indicesList.toArray();
            for (int i = 0; i < indices.length; ++i) {
                int index = (Integer)indices[i];
                PageWindowInternal window = this.windows.get(index);
                if (window.pageId != pageId) continue;
                this.removePage(window.pageId, window.versionNumber, window.ajaxVersionNumber);
            }
        }
    }

    public synchronized List<PageWindow> getLastPageWindows(int count) {
        ArrayList<PageWindow> result = new ArrayList<PageWindow>();
        int currentIndex = this.indexPointer;
        while (currentIndex != -1) {
            PageWindowInternal window = this.windows.get(currentIndex);
            if (window.pageId != -1) {
                result.add(new PageWindow(window));
            }
            if (--currentIndex == -1) {
                currentIndex = result.size() - 1;
            }
            if (result.size() < count && currentIndex != this.indexPointer) continue;
        }
        return result;
    }

    public PageWindowManager(int maxSize) {
        this.maxSize = maxSize;
    }

    public int getTotalSize() {
        return this.totalSize;
    }

    public static class PageWindow {
        private final PageWindowInternal pageWindowInternal;

        private PageWindow(PageWindowInternal pageWindowInternal) {
            this.pageWindowInternal = pageWindowInternal;
        }

        public int getPageId() {
            return this.pageWindowInternal.pageId;
        }

        public int getVersionNumber() {
            return this.pageWindowInternal.versionNumber;
        }

        public int getAjaxVersionNumber() {
            return this.pageWindowInternal.ajaxVersionNumber;
        }

        public int getFilePartOffset() {
            return this.pageWindowInternal.filePartOffset;
        }

        public int getFilePartSize() {
            return this.pageWindowInternal.filePartSize;
        }
    }

    private static class PageWindowInternal
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int pageId;
        private short versionNumber;
        private short ajaxVersionNumber;
        private int filePartOffset;
        private int filePartSize;

        private PageWindowInternal() {
        }
    }
}

